/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

define([
    'jquery',
    'WriteTextAI_WriteTextAI/js/model/edit/gallery'
], function ($, gallery) {
    'use strict';

    /**
     * Update images
     *
     * @param {string} selectAll
     * @param {Array} images
     * @param {Array} imagesSelected
     * @param {boolean} imagesSelectedAvailable
     *
     * @return void
     */
    function updateImages(selectAll, images)
    {
        var selectAllImages = JSON.parse(selectAll.toLowerCase()),
            imageIds = [];

        if (selectAllImages && Array.isArray(images)) {
            images.forEach(function (img) {
                imageIds.push(img.id);
            });
        }

        gallery.images(images);
        gallery.selectAllImages(selectAllImages);
        gallery.selectedImages(imageIds);
    }

    return {
        updateImages: updateImages
    }
});