/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

define([
    'jquery',
    'ko',
    'uiComponent'
], function ($, ko, Component) {
    'use strict';

    return Component.extend({
        defaults: {
            isVisible: true
        },
        
        /**
         * @inheritdoc
         */
        initialize: function (config) {
            this._super();

            self = this;
        },

        initObservable: function () {
            this._super()
                .observe([
                    'isVisible'
                ]);

            return this;
        },
        
        /**
         * Dismiss the notice and send AJAX request
         */
        dismissNotice: function () {
            var self = this;
            
            /* Hide the notice */
            self.isVisible(false);
            
            
            /* Send AJAX request to save the preference server-side */
            $.ajax({
                url: self.dismissUrl,
                type: 'POST',
                dataType: 'json',
                data: {
                    form_key: window.FORM_KEY,
                    review_notice_dismissed: true,
                    entity_type: '',
                },
                success: function (response) {
                    /* Optional success handling */
                }
            });
        }
    });
}); 