/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

define(['ko', 'domReady!'], function (ko) {
    'use strict';

    var pageTitle = ko.observable(),
        pageDescription = ko.observable(),
        productDescription = ko.observable(),
        productShortDescription = ko.observable(),
        openGraph = ko.observable(),
        selectedFields = ko.observableArray([]),
        highlightPronouns = ko.observable(),
        formal = ko.observable(),
        mgPageTitle = ko.observable(),
        mgPageDescription = ko.observable(),
        mgProductDescription = ko.observable(),
        mgProductShortDescription = ko.observable(),
        mgOpenGraph = ko.observable(),

        /**
         * handles unsaved changes
         */
        originalPageTitle = ko.observable(),
        originalPageDescription = ko.observable(),
        originalProductDescription = ko.observable(),
        originalProductShortDescription = ko.observable(),
        originalOpenGraph = ko.observable(),

        statuses = ko.observable({
            pageTitleGenerateStatus: false,
            pageDescriptionGenerateStatus: false,
            productDescriptionGenerateStatus: false,
            productShortDescriptionGenerateStatus: false,
            openGraphGenerateStatus: false,
            pageTitleTransferStatus: false,
            pageDescriptionTransferStatus: false,
            productDescriptionTransferStatus: false,
            productShortDescriptionTransferStatus: false,
            openGraphTransferStatus: false,
        }),

        useDefault = ko.observable({
            pageTitle: true,
            pageDescription: true,
            productDescription: true,
            productShortDescription: true,
            openGraph: true
        }),

        keywordsUsed = ko.observable({
            pageTitle: [],
            pageDescription: [],
            productDescription: [],
            productShortDescription: [],
            openGraph: []
        });

    return {
        pageTitle: pageTitle,
        pageDescription: pageDescription,
        productDescription: productDescription,
        productShortDescription: productShortDescription,
        openGraph: openGraph,
        selectedFields: selectedFields,
        originalPageTitle: originalPageTitle,
        originalPageDescription: originalPageDescription,
        originalProductDescription: originalProductDescription,
        originalProductShortDescription: originalProductShortDescription,
        originalOpenGraph: originalOpenGraph,
        mgPageTitle: mgPageTitle,
        mgPageDescription: mgPageDescription,
        mgProductDescription: mgProductDescription,
        mgProductShortDescription: mgProductShortDescription,
        mgOpenGraph: mgOpenGraph,
        highlightPronouns: highlightPronouns,
        formal: formal,
        statuses: statuses,
        useDefault: useDefault,
        keywordsUsed: keywordsUsed
    };
});
