/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

define([
    'jquery',
    'ko',
    'jquery/ui',
    'Magento_Ui/js/modal/confirm'
], function ($, ko) {
    'use strict';

    $.widget('writetextai.confirm', $.mage.confirm, {
        options: {
            overlayClass: 'modals-overlay wtai-overlay-bulk-action'
        },

        /**
         * Close modal window.
         *
         * @param {Event} event
         * @param {Boolean} result
         *
         * @returns {Boolean}
         */
        closeModal: function (event, result) {
            var response = this._super(event, result);

            /**
             * remove previous popup
             */
            ko.cleanNode($('#wtaiPrompt'));
            ko.cleanNode($('#wtaiGenerateButton'));
            ko.cleanNode($('#wtaiFullAutomationPrompt'));
            $('.wtai-overlay-bulk-action').remove();
            $('.wtai-modal').remove();

            return response;
        }
    });

    return function (config) {
        return $('<div></div>').html(config.content).confirm(config);
    };
});
