/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

define([
    'jquery',
    'ko',
    'Magento_Ui/js/grid/columns/column',
    'WriteTextAI_WriteTextAI/js/model/pro-badge'
], function (
    $,
    ko,
    Column,
    proBadge
) {
    'use strict';

    return Column.extend({
        defaults: {
            headerTmpl: 'WriteTextAI_WriteTextAI/grid/columns/traffic-potential'
        },

        /** @inheritdoc */
        initialize: function () {
            this._super();
        },

        initObservable: function () {
            this._super()
                .observe([]);

            this.showBadge = ko.computed(function () {
                return proBadge.showBadge();
            }, this);

            return this;
        },

        /**
         * Get header css classes.
         */
        getCssClasses: function () {
            return 'data-grid-th wtai-th-traffic_potential';
        }
    });
});
