/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

define([
    'jquery',
    'underscore',
    'Magento_Ui/js/form/element/ui-select',
    'WriteTextAI_WriteTextAI/js/model/setup/data-mapping'
], function ($, _, Select, dataMapping) {
    'use strict';

    return Select.extend({
        defaults: {
            customOpenGraphSelector:
                '#wtaiStep2Form input[name="custom_open_graph"]',
            customOpenGraph: false,
            fieldName: ''
        },

        /** @inheritdoc */
        initialize: function () {
            this._super();

            this.setInitValue();

            return this;
        },

        /** @inheritdoc */
        initObservable: function () {
            this._super().observe(['customOpenGraph', 'fieldName']);

            return this;
        },

        /** @inheritdoc */
        toggleOptionSelected: function (data) {
            var value = '',
                fieldName = '';

            this._super(data);

            value = this.value();
            fieldName = this.fieldName();

            switch (fieldName) {
                case 'page_title':
                    dataMapping.pageTitle(value);
                    break;
                case 'page_description':
                    dataMapping.pageDescription(value);
                    break;
                case 'product_description':
                    dataMapping.productDescription(value);
                    break;
                case 'short_product_description':
                    dataMapping.productShortDescription(value);
                    break;
                case 'open_graph':
                    dataMapping.openGraph(value);
                    break;
            }

            return this;
        },

        /**
         * Set initial value
         */
        setInitValue: function () {
            var self = this,
                value = this.value(),
                fieldName = this.fieldName();

            switch (fieldName) {
                case 'page_title':
                    dataMapping.pageTitle(value);
                    break;
                case 'page_description':
                    dataMapping.pageDescription(value);
                    break;
                case 'product_description':
                    dataMapping.productDescription(value);
                    break;
                case 'short_product_description':
                    dataMapping.productShortDescription(value);
                    break;
                case 'open_graph':
                    dataMapping.openGraph(value);
                    break;
            }

            if ($(this.customOpenGraphSelector).is(':checked')) {
                self.customOpenGraph(true);
            }

            $(this.customOpenGraphSelector).on('change', function () {
                self.customOpenGraph($(this).is(':checked'));
            });
        },

        /**
         * Check if option is disabled
         *
         * @param {*} option
         * @return {Boolean}
         */
        isDisabled: function (option) {
            var fields = [
                dataMapping.pageTitle(),
                dataMapping.pageDescription(),
                dataMapping.productDescription(),
                dataMapping.productShortDescription()
            ];

            if (this.customOpenGraph()) {
                fields.push(dataMapping.openGraph());
            }

            return (
                _.contains(fields, option.value) &&
                this.value() !== option.value
            );
        }
    });
});
