/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

define([
    'jquery',
    'ko',
    'uiComponent',
    'underscore',
    'WriteTextAI_WriteTextAI/js/model/edit/mark-reviewed',
    'WriteTextAI_WriteTextAI/js/model/edit/product',
    'WriteTextAI_WriteTextAI/js/model/edit/error-messages',
    'WriteTextAI_WriteTextAI/js/model/edit/textfields'

], function (
    $,
    ko,
    Component,
    _,
    markReviewed,
    product,
    errorMessagesModel,
    textfields
) {
    'use strict';

    /**
     * @var {Component} self
     */
    var self;

    return Component.extend({
        defaults: {
            reviewed: false
        },

        isMarkedReviewChange: false,

        /** @inheritdoc */
        initialize: function () {
            this._super();

            self = this;

            const el = document.querySelector('.wtai-mark-reviewed');
            if (el) {
                $('.wtai-mark-reviewed > *').applyBindings(this);
            }

            markReviewed.reviewed.subscribe(function (reviewed) {
                self.isMarkedReviewChange = true;
                self.reviewed(reviewed);
                self.isMarkedReviewChange = false;
            });

            self.reviewed.subscribe(function (reviewed) {
                if (!self.isMarkedReviewChange) {
                    self.markReviewed(reviewed);
                }
            });
        },

        /** @inheritdoc */
        initObservable: function () {
            this._super()
                .observe([
                    'reviewed'
                ]);

            this.canReview = ko.computed(function () {
                var statuses = textfields.statuses(),
                    allowReview = this.isReviewAllowed,
                    transferStatuses = [
                        statuses.pageTitleTransferStatus,
                        statuses.pageDescriptionTransferStatus,
                        statuses.productDescriptionTransferStatus,
                        statuses.productShortDescriptionTransferStatus
                    ];

                if (this.customOpenGraph) {
                    transferStatuses.push(statuses.openGraphTransferStatus);
                }

                var allFieldsTransferred = transferStatuses.every(function (status) {
                    return status === true;
                });

                return allowReview && !allFieldsTransferred;
            }, this);

            return this;
        },

        /**
         * Mark as reviewed
         *
         * @param {boolean} reviewed
         * @returns {void}
         */
        markReviewed: function (reviewed) {
            errorMessagesModel.messages([]);

            $.ajax({
                url: self.markReviewUrl,
                type: 'POST',
                data: {
                    reviewed: reviewed,
                    product_id: product.productId(),
                    store_id: product.storeId()
                },
                dataType: 'json',
                showWriteTextAILoader: true,
                success: function (response) {
                    if (!response.success) {
                        errorMessagesModel.messages.push(response.message);
                        self.isMarkedReviewChange = true;
                        self.reviewed(!reviewed);
                        self.isMarkedReviewChange = false;
                    } else {
                        markReviewed.reviewed(reviewed);
                    }
                }
            });
        }
    });
});
