/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

define([
    "jquery",
    "ko",
    "mage/translate",
    "uiComponent",
    "underscore",
    'WriteTextAI_WriteTextAI/js/edit/keywords/keyword-analysis',
    'WriteTextAI_WriteTextAI/js/model/edit/keywords/keyword-analysis',
    'WriteTextAI_WriteTextAI/js/model/edit/keywords/keywords',
    "Magento_Ui/js/modal/modal"
], function (
    $,
    ko,
    $t,
    Component,
    _,
    keywordAnalysisComponent,
    keywordAnalysis,
    keywordsData
) {
    'use strict';

    /**
     * @var {Component} self
     */
    var self;

    return Component.extend({
        defaults: {
        },

        /** @inheritdoc */
        initialize: function () {
            this._super();

            self = this;

            const el = document.querySelector('.wtai-keywords-invalid-image-popup');
            if (el) {
                $('.wtai-keywords-invalid-image-popup > *').applyBindings(this);
            }

            this.initModal();
        },

        /** @inheritdoc */
        initObservable: function () {
            this._super()
                .observe([
                ]);

            this.showProceed = ko.computed(function () {
                return keywordAnalysis.imageUploadFailed();
            });

            this.getThumbnail = ko.computed(function () {
                return keywordsData.thumbnail();
            });

            this.uploadErrorMessage = ko.computed(function () {
                return keywordAnalysis.uploadErrorMessage();
            });

            return this;
        },

        /**
         * Initialize modal
         */
        initModal: function () {
            $('.wtai-keywords-invalid-image-popup').modal({
                type: 'popup',
                responsive: true,
                title: $t('Some images could not be processed:'),
                modalClass: 'wtai-keywords-invalid-image-popup-modal',
                overlayClass: 'modals-overlay wtai-keywords-invalid-image-popup-overlay',
                buttons: [{
                    text: $t('Cancel'),
                    class: 'action-secondary action-dismiss',
                    click: function () {
                        keywordAnalysis.optimizing(false);
                        keywordAnalysis.isUploading(false);
                        keywordAnalysis.imageUploadFailed(false);
                        this.closeModal();
                    }
                }, {
                    text: $t('Proceed'),
                    class: 'action-primary wtai-action-proceed',
                    click: function () {
                        keywordAnalysisComponent.prototype.proceed();
                        this.closeModal();
                    }
                }],
                closed: function () {
                    $('.modals-overlay.wtai-keywords-invalid-image-popup-overlay').remove();
                },
                opened: function () {
                    $('.wtai-invalid-image-popup-modal .modal-footer .action-dismiss').toggle(self.showProceed());
                    $('.wtai-invalid-image-popup-modal .modal-footer .wtai-action-proceed').toggle(self.showProceed());
                }
            });
        }
    });
});
