/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

define([
    'Magento_Ui/js/grid/columns/thumbnail'
], function (Thumbnail) {
    'use strict';

    return Thumbnail.extend({
        /**
         * Get image source data per row.
         *
         * @param {Object} row
         * @returns {String}
         */
        getSrc: function (row) {
            if (row['wtai_' + this.index + '_src']) {
                return row['wtai_' + this.index + '_src'];
            } else {
                return row[this.index + '_src'];
            }
        },

        /**
         * Get original image source data per row.
         *
         * @param {Object} row
         * @returns {String}
         */
        getOrigSrc: function (row) {
            if (row['wtai_' + this.index + '_orig_src']) {
                return row['wtai_' + this.index + '_orig_src'];
            } else {
                return row[this.index + '_orig_src'];
            }
        },

        /**
         * Get field handler per row.
         *
         * @param {Object} row
         * @returns {Function}
         */
        getFieldHandler: function (row) {
            if (this.isPreviewAvailable() && row[this.index]) {
                return this.preview.bind(this, row);
            }
        },
         
        /**
         * Is preview available.
         */
        isVisible: function (row) {
            if (row[this.index]) {
                return true;
            } else {
                return false;
            }
        },

        /**
         * Get alternative text data per row.
         *
         * @param {Object} row
         * @returns {String}
         */
        getAlt: function (row) {
            return '';
        },
    });
});
