<?php
/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

namespace WriteTextAI\WriteTextAI\WtaiTrait;

/**
 * Trait for collecting premium account data
 */
trait PremiumDataTrait
{
    /**
     * Collect premium data
     *
     * @return array
     */
    protected function collectPremiumData($refreshCachedData = false)
    {
        try {
            $premiumData = [
                'total_credits' => $this->premium->getTotalCredits($refreshCachedData),
                'available_credits' => $this->premium->getAvailableCredits(),
                'is_premium' => $this->premium->getIsPremium(),
                'is_free_premium_credits' => $this->premium->getFreePremiumCredits(),
                'is_already_premium' => $this->premium->getFreeCreditsAlreadyPremium(),
                'is_welcome_premium_20' => $this->premium->getWelcomePremium20(),
                'is_unlocked_premium' => $this->premium->getUnlockedPremium(),
                'is_unlocked_free_trial' => $this->premium->getUnlockedFreeTrial(),
                'is_no_credits_free_trial' => $this->premium->getNoCreditsFreeTrial(),
                'is_unlocked_professional' => $this->premium->getUnlockedProfessional(),
                'is_unlocked_enterprise' => $this->premium->getUnlockedEnterprise(),
                'membership_type' => $this->premium->getMembershipType(),
                'has_pro_access' => $this->premium->getHasProAccess(),
                'subscription_expiration' => $this->premium->getSubscriptionExpiration(),
                'is_terms_accepted' => true
            ];
        } catch (\WriteTextAI\WriteTextAI\Exception\TermsException $e) {
            $premiumData = [
                'total_credits' => 0,
                'available_credits' => 0,
                'is_premium' => false,
                'is_free_premium_credits' => false,
                'is_already_premium' => false,
                'is_welcome_premium_20' => false,
                'is_unlocked_premium' => false,
                'is_unlocked_free_trial' => false,
                'is_no_credits_free_trial' => false,
                'is_unlocked_professional' => false,
                'is_unlocked_enterprise' => false,
                'membership_type' => '',
                'has_pro_access' => false,
                'subscription_expiration' => '',
                'is_terms_accepted' => false
            ];
        }
        
        return $premiumData;
    }
}
