<?php
/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

namespace WriteTextAI\WriteTextAI\ViewModel;

use WriteTextAI\WriteTextAI\Model\UserFieldsSelectedManager;

class UserFieldsSelected implements \Magento\Framework\View\Element\Block\ArgumentInterface
{
    /**
     * @var UserFieldsSelectedManager
     */
    protected $userFieldsSelectedManager;

    /**
     * @var array
     */
    protected $data = [];
    
    /**
     * Constructor
     *
     * @param UserFieldsSelectedManager $userFieldsSelectedManager
     */
    public function __construct(
        UserFieldsSelectedManager $userFieldsSelectedManager
    ) {
        $this->userFieldsSelectedManager = $userFieldsSelectedManager;
    }

    /**
     * Get settings
     *
     * @param string $name
     * @param string $entityType
     * @param string $scope
     * @param bool $reset
     *
     * @return array
     */
    public function getUserFieldsSelected($name, $entityType, $scope, $reset = false)
    {
        if (isset($this->data[$entityType][$scope][$name]) && !$reset) {
            return $this->data[$entityType][$scope][$name];
        }

        return $this->getValue($name, $entityType, $scope);
    }

    /**
     * Set value
     *
     * @param string $name
     * @param array $value
     * @param string $entityType
     * @param string $scope
     * @return void
     */
    public function setValue($name, $value, $entityType, $scope)
    {
        $this->data[$entityType][$scope][$name] = $value;
    }
    
    /**
     * Get value
     *
     * @param string $name
     * @param string $entityType
     * @param string $scope
     *
     * @return array
     */
    protected function getValue($name, $entityType, $scope)
    {
        $value = $this->userFieldsSelectedManager->getUserFieldsSelected($name, $entityType, $scope);
        $this->setValue($name, $value, $entityType, $scope);

        return $value;
    }
}
