<?php
/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

namespace WriteTextAI\WriteTextAI\Ui\Components\Categories\Listing\Column;

use Magento\Ui\Component\Listing\Columns\Column;

class Actions extends Column
{
    /**
     * Prepare Data Source
     *
     * @param array $dataSource
     * @return array
     */
    public function prepareDataSource(array $dataSource)
    {
        if (isset($dataSource['data']['items'])) {
            foreach ($dataSource['data']['items'] as &$item) {
                $name = $this->getData('name');
                if (isset($item['entity_id'])) {
                    $item[$name]['edit'] = [
                        'label' => __('Edit'),
                        'record_id' => $item['entity_id'],
                        'store_id' => $item['store_id']
                    ];
                    if ($item['path'] !== null
                        && $item['path'] !== ''
                        && (int)$item['status'] === 1
                    ) {
                        $item[$name]['view'] = [
                            'label' => __('View'),
                            'href'  => $item['view_url'],
                            'target' => '_blank'
                        ];
                    }
                }
            }
        }

        return $dataSource;
    }
}
