# WriteText.ai

WriteText.ai lets you generate product descriptions and SEO texts right inside Magento. No more import-export for your AI-generated text.

With WriteText.ai, you'll experience AI-powered copywriting with the convenience of working directly inside Magento.

WriteText.ai takes your existing product attributes including your product images and uses them as a basis for generating meta titles, meta descriptions, product descriptions, and Open Graph text, so you don’t even have to worry about coming up with the right prompts. 

## Installation

### Minimum Requirements

* Magento version 2.4.4 or later. Tested up to 2.4.8.
* PHP version 8.1 or later.

### Using Zip file

 - Unzip the zip file in `app/code/WriteTextAI`
 - Enable the extension by running `php bin/magento module:enable WriteTextAI_WriteTextAI`
 - Run the following commands to upgrade, deploy, and clean the cache.
   - `php bin/magento setup:upgrade --keep-generated`
   - `php bin/magento setup:di:compile`
   - `php bin/magento setup:static-content:deploy -f`
   - `php bin/magento cache:clean`

### Using Composer

 - Install the extension by running `composer require writetextai/writetextai`
 - Enable the extension by running `php bin/magento module:enable WriteTextAI_WriteTextAI`
 - Run the following commands to upgrade, deploy, and clean the cache.
   - `php bin/magento setup:upgrade --keep-generated`
   - `php bin/magento setup:di:compile`
   - `php bin/magento setup:static-content:deploy -f`
   - `php bin/magento cache:clean`

## Features

- Connection to an unlimited number of ecommerce sites and user accounts.
- Direct content transfer and publishing to Magento.
- Selection of product attributes, tone, and style.
- Customizable content length, target audience, and user roles.
- Advanced image analysis particularly for products with limited data
- AI suggestions for target markets.
- Keyword analysis and semantic keyword suggestions.
- Keyword density tracking for SEO.
- Text rewriting.
- Reference product, ensuring that the tone, style and layout follows and an existing product. 
- Content review history log and bulk content management.
- Multi-store support.
- Chrome extension for content management and tagging of products for fact checking or rewriting. 

## WriteText.ai Single

This mode enables users to define the tone, style, and target market for a specific product, do detailed keyword analysis, and select semantic keywords along with specific product attributes for consideration in the generated text. WriteText.ai generates text within approximately 50 seconds, after which users can review and adjust the text before publishing. This mode focuses on creating tailored content for specific audience needs, with an emphasis on SEO.

## WriteText.ai Bulk

For generating text for multiple products simultaneously, WriteText.ai Bulk allows for the selection of multiple products to generate text in a single operation, applying a consistent tone, style, and attributes across all selected products. This mode is optimized for speed and efficiency, streamlining the content creation process for large-scale needs.

## Languages Supported

To cater to a global audience, Version 1.20.5 includes support for multiple languages, including Danish, Swedish, Norwegian, German, French, Portuguese, Spanish, Catalan, Dutch, and Italian. This feature allows businesses to automatically generate content in the language of their Magento webshop, broadening their market reach and enhancing customer engagement across different regions.

WriteText.ai auto-adjusts its output to your webshop's language. Should the language be unavailable, English is set as the default. The interface is being translated and will launch in the third week of March. Until then, it remains in English.

## Other Details

WriteText.ai relies on third-party services to fulfill different functions in the extension. Our own proprietary API ([https://writetext.ai/](https://writetext.ai/)) is used for:

- Connecting to the appropriate regional server to ensure performance
- Validating the user’s premium status or subscription and monitoring credit balance
- Calculating the credit cost for certain actions
- Getting up-to-date keyword data
- Generating semantic keywords
- Generating text
- Fetching history log

The user must have a valid account at [https://platform.writetext.ai](https://platform.writetext.ai) in order to connect to this service. This connection is done upon installation through a setup wizard. You can read the [Terms of Service](https://platform.writetext.ai/terms) and the [Privacy Notice](https://platform.writetext.ai/privacy) in our website.

SignalR is a third-party JS file that is used to send asynchronous notifications. In WriteText.ai, this is in the form of streaming text to the user as soon as the generation starts while the rest of the text is still being processed and received.
This is used to improve the user experience by providing a visual signal that progress is being made (i.e., via streaming the text) while text generation is not yet fully finished and to display notifications for certain bulk actions.

The user only needs their WriteText.ai account at [https://platform.writetext.ai](https://platform.writetext.ai) in order to connect to this service. [raw.githubusercontent.com/stefanpenner/es6-promise/master/LICENSE](https://raw.githubusercontent.com/stefanpenner/es6-promise/master/LICENSE) points to the license text for SignalR and is required to be included in the extension as part of the license conditions.

OwlCarousel2 is a touch enabled jQuery plugin that lets you create a beautiful, responsive carousel slider. In WriteText.ai, it is used to display review statuses from the chrome extension. 

[https://github.com/OwlCarousel2/OwlCarousel2/blob/develop/LICENSE](https://github.com/OwlCarousel2/OwlCarousel2/blob/develop/LICENSE) points to the license text for OwlCarousel2 and is required to be included in the extension as part of the license conditions.

## FAQ

#### What basis does WriteText.ai use to generate product texts?

Out of the box, WriteText.ai takes your product name and (if available) product attributes and uses all this information to generate text. Aside from this, you have the ability to set the tone, style, and target audience in order to influence how the text will be written.

With premium features, you can also set target keywords and select related semantic keywords, add other product details, analyze your product images, and write your own custom tone, style, and audience. WriteText.ai will take them into consideration when generating your product text.

#### How accurate is the AI-generated text?

The more information available for your product (i.e., attributes, target keywords and semantic keywords, other product details, images), the more accurate WriteText.ai can be when generating your product text. If you generate text with only the product name as the available information, WriteText.ai will still generate text but it may not be as accurate as when you have more complete product information.

#### Can I be sure that the text generated is 100% unique?

We cannot assure 100% text uniqueness as it's generated by artificial intelligence. However, given that the AI is guided by your keywords (from your keyword analysis) and chosen product attribute(s), there's a high likelihood of producing unique text. The "Other product details" feature enables you to provide written instructions to the AI, enhancing text uniqueness even further.

We recommend reviewing the text prior to publishing to ensure it aligns with your standards and desired uniqueness level.

#### How can I ensure the quality of the generated text?

In general, the more information that you provide about your product (e.g., keywords and semantic keywords, product attributes, other product details), the higher quality the text that WriteText.ai will generate for you, especially if you have a longer target length.

If you encounter nonsensical phrases in the generated text, try the following:

- Provide more context by adding target keywords and selecting semantic keywords.
- Ensure that the product attributes are properly set.
- Add more information in the "Other product details" field.
- Set a shorter maximum length for product descriptions.

#### How can I ensure that the generated product text is SEO friendly?

WriteText.ai has a Keyword Analysis tool* where you can set target keywords and get up-to-date data on search volume and competition. We recommend setting the right keywords (including choosing relevant semantic keywords) for your product so WriteText.ai can incorporate them in generating the text.

*Keyword Analysis is a premium feature.

## Screenshots
- Get an overview of your products and their corresponding texts
- Set the tone, style, audience, and length for bulk generation
- Add target keywords and get suggested semantic keywords based on them
- Built-in keyword analysis tool with up-to-date search volume and difficulty data
- Select the product attributes you want to consider in generating text
- Choose from predefined tones and styles or write your own
- Select your audience or get AI-suggested target markets
- Generate SEO-optimized image alt text

## Upgrade Notice

Please upgrade, to ensure all extension features works as expected.

### Using Zip file

 - Unzip the updated zip file in `app/code/WriteTextAI`
 - Run the following commands to upgrade, deploy, and clean the cache.
   - `php bin/magento setup:upgrade --keep-generated`
   - `php bin/magento setup:di:compile`
   - `php bin/magento setup:static-content:deploy -f`
   - `php bin/magento cache:clean`

### Using Composer

 - Update the extension by running `composer update writetextai/writetextai`
 - Run the following commands to upgrade, deploy, and clean the cache.
   - `php bin/magento setup:upgrade --keep-generated`
   - `php bin/magento setup:di:compile`
   - `php bin/magento setup:static-content:deploy -f`
   - `php bin/magento cache:clean`

## License

[GPLv3 or later](https://www.gnu.org/licenses/gpl-3.0.en.html)