<?php
/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

namespace WriteTextAI\WriteTextAI\Plugin\Framework\View;

use Magento\Framework\App\RequestInterface;

class Layout
{
    /**
     * @var RequestInterface
     */
    protected $request;

    /**
     * Constructor
     *
     * @param RequestInterface $request
     */
    public function __construct(
        RequestInterface $request
    ) {
        $this->request = $request;
    }

    /**
     * Disable cache for product info blocks
     *
     * @param \Magento\Framework\View\Layout $subject
     * @param bool $result
     * @return bool
     */
    public function afterIsCacheable(\Magento\Framework\View\Layout $subject, $result)
    {
        $blockNames = [
            'product.info',
            'product.info.addto',
            'product.info.addtocart',
            'product.info.overview',
            'category.description'
        ];
        
        foreach ($blockNames as $blockName) {
            if ($subject->hasElement($blockName) &&
                $this->request->getParam('wtai-preview')
            ) {
                $result = false;
                break;
            }
        }

        return $result;
    }
}
