<?php
/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

namespace WriteTextAI\WriteTextAI\Plugin\Component\Listing\Columns;

use Magento\Ui\Component\Listing\Columns\Column as BaseColumn;
use WriteTextAI\WriteTextAI\Helper\Fields as FieldsHelper;
use WriteTextAI\WriteTextAI\Helper\Data as DataHelper;

class Column
{
    /**
     * @var FieldsHelper
     */
    protected $helper;

    /**
     * @var DataHelper
     */
    protected $dataHelper;

    /**
     * Constructor
     *
     * @param FieldsHelper $helper
     * @param DataHelper $dataHelper
     */
    public function __construct(
        FieldsHelper $helper,
        DataHelper $dataHelper
    ) {
        $this->helper = $helper;
        $this->dataHelper = $dataHelper;
    }

    /**
     * Before prepare
     *
     * @param BaseColumn $subject
     * @return void
     */
    public function beforePrepare(BaseColumn $subject)
    {
        $columnData = $subject->getData();
        $customOpenGraph = $this->dataHelper->getCustomOpenGraph();

        if (!$customOpenGraph) {
            switch ($columnData['name']) {
                case 'mg_open_graph':
                case 'ai_open_graph':
                    $columnData['config']['componentDisabled'] = true;
                    break;
                case 'mg_short_product_description':
                    $columnData['config']['label'] = __('Magento short description');
                    break;
                case 'ai_short_product_description':
                    $columnData['config']['label'] = __('WriteText.ai short description');
                    break;
            }
            
            $subject->setData($columnData);
        }
    }

    /**
     * Get label
     *
     * @param string $field
     * @return string
     */
    protected function getLabel($field)
    {
        $fields = $this->helper->getFieldLabels();
        $label = '';
        if (isset($fields[$field])) {
            $label = $fields[$field]['label'];
        }

        return $label;
    }
}
