<?php
/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

declare(strict_types=1);

namespace WriteTextAI\WriteTextAI\Model;

use Magento\Framework\Model\AbstractModel;
use WriteTextAI\WriteTextAI\Api\Data\UserFieldsSelectedInterface;

class UserFieldsSelected extends AbstractModel implements UserFieldsSelectedInterface
{
    /**
     * @inheritDoc
     */
    public function _construct()
    {
        $this->_init(\WriteTextAI\WriteTextAI\Model\ResourceModel\UserFieldsSelected::class);
    }

    /**
     * @inheritDoc
     */
    public function getUserfieldsselectedId()
    {
        return $this->getData(self::USERFIELDSSELECTED_ID);
    }

    /**
     * @inheritDoc
     */
    public function setUserfieldsselectedId($userfieldsselectedId)
    {
        return $this->setData(self::USERFIELDSSELECTED_ID, $userfieldsselectedId);
    }

    /**
     * @inheritDoc
     */
    public function getValue()
    {
        return $this->getData(self::VALUE);
    }

    /**
     * @inheritDoc
     */
    public function setValue($value)
    {
        return $this->setData(self::VALUE, $value);
    }

    /**
     * @inheritDoc
     */
    public function getField()
    {
        return $this->getData(self::FIELD);
    }

    /**
     * @inheritDoc
     */
    public function setField($field)
    {
        return $this->setData(self::FIELD, $field);
    }

    /**
     * @inheritDoc
     */
    public function getUserId()
    {
        return $this->getData(self::USER_ID);
    }

    /**
     * @inheritDoc
     */
    public function setUserId($userId)
    {
        return $this->setData(self::USER_ID, $userId);
    }

    /**
     * @inheritDoc
     */
    public function getActionType()
    {
        return $this->getData(self::ACTION_TYPE);
    }

    /**
     * @inheritDoc
     */
    public function setActionType($actionType)
    {
        return $this->setData(self::ACTION_TYPE, $actionType);
    }

    /**
     * @inheritDoc
     */
    public function getFields()
    {
        return $this->getData(self::FIELDS);
    }

    /**
     * @inheritDoc
     */
    public function setFields($fields)
    {
        return $this->setData(self::FIELDS, $fields);
    }
}
