<?php
/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

namespace WriteTextAI\WriteTextAI\Model;

use WriteTextAI\WriteTextAI\Model\Api\CurlBuilder;
use WriteTextAI\WriteTextAI\Helper\Store as StoreHelper;

/**
 * @api
 */
class TemplatesApiManager
{
    /**
     * @var CurlBuilder
     */
    protected $curlBuilder;

    /**
     * @var StoreHelper
     */
    protected $storeHelper;

    /**
     * Constructor
     *
     * @param CurlBuilder $curlBuilder
     * @param StoreHelper $storeHelper
     */
    public function __construct(
        CurlBuilder $curlBuilder,
        StoreHelper $storeHelper
    ) {
        $this->curlBuilder = $curlBuilder;
        $this->storeHelper = $storeHelper;
    }

    /**
     * Get current template settings
     *
     * @return array
     */
    public function getCurrentTemplateSettings()
    {
        try {
            return $this->curlBuilder->getApiResponse('web/TemplateSettings/current');
        } catch (\WriteTextAI\WriteTextAI\Exception\ApiException $e) {
            return [];
        }
    }
}
