<?php
/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */
declare(strict_types=1);

namespace WriteTextAI\WriteTextAI\Model;

use Magento\Framework\Api\SearchCriteria\CollectionProcessorInterface;
use Magento\Framework\Exception\CouldNotDeleteException;
use Magento\Framework\Exception\CouldNotSaveException;
use Magento\Framework\Exception\NoSuchEntityException;
use WriteTextAI\WriteTextAI\Api\Data\SingleGenerateRequestsInterface;
use WriteTextAI\WriteTextAI\Api\Data\SingleGenerateRequestsInterfaceFactory;
use WriteTextAI\WriteTextAI\Api\Data\SingleGenerateRequestsSearchResultsInterfaceFactory;
use WriteTextAI\WriteTextAI\Api\SingleGenerateRequestsRepositoryInterface;
use WriteTextAI\WriteTextAI\Model\ResourceModel\SingleGenerateRequests as ResourceSingleGenerateRequests;
use WriteTextAI\WriteTextAI\Model\ResourceModel\SingleGenerateRequests\CollectionFactory
    as SingleGenerateRequestsCollectionFactory;

class SingleGenerateRequestsRepository implements SingleGenerateRequestsRepositoryInterface
{

    /**
     * @var SingleGenerateRequestsCollectionFactory
     */
    protected $singleGenerateRequestsCollectionFactory;

    /**
     * @var SingleGenerateRequests
     */
    protected $searchResultsFactory;

    /**
     * @var CollectionProcessorInterface
     */
    protected $collectionProcessor;

    /**
     * @var ResourceSingleGenerateRequests
     */
    protected $resource;

    /**
     * @var SingleGenerateRequestsInterfaceFactory
     */
    protected $singleGenerateRequestsFactory;

    /**
     * @param ResourceSingleGenerateRequests $resource
     * @param SingleGenerateRequestsInterfaceFactory $singleGenerateRequestsFactory
     * @param SingleGenerateRequestsCollectionFactory $singleGenerateRequestsCollectionFactory
     * @param SingleGenerateRequestsSearchResultsInterfaceFactory $searchResultsFactory
     * @param CollectionProcessorInterface $collectionProcessor
     */
    public function __construct(
        ResourceSingleGenerateRequests $resource,
        SingleGenerateRequestsInterfaceFactory $singleGenerateRequestsFactory,
        SingleGenerateRequestsCollectionFactory $singleGenerateRequestsCollectionFactory,
        SingleGenerateRequestsSearchResultsInterfaceFactory $searchResultsFactory,
        CollectionProcessorInterface $collectionProcessor
    ) {
        $this->resource = $resource;
        $this->singleGenerateRequestsFactory = $singleGenerateRequestsFactory;
        $this->singleGenerateRequestsCollectionFactory = $singleGenerateRequestsCollectionFactory;
        $this->searchResultsFactory = $searchResultsFactory;
        $this->collectionProcessor = $collectionProcessor;
    }

    /**
     * @inheritDoc
     */
    public function save(
        SingleGenerateRequestsInterface $singleGenerateRequests
    ) {
        try {
            $this->resource->save($singleGenerateRequests);
        } catch (\Exception $exception) {
            throw new CouldNotSaveException(__(
                'Could not save the singleGenerateRequests: %1',
                $exception->getMessage()
            ));
        }
        return $singleGenerateRequests;
    }

    /**
     * @inheritDoc
     */
    public function get($singleGenerateRequestsId)
    {
        $singleGenerateRequests = $this->singleGenerateRequestsFactory->create();
        $this->resource->load($singleGenerateRequests, $singleGenerateRequestsId);
        if (!$singleGenerateRequests->getId()) {
            throw new NoSuchEntityException(__(
                'single_generate_requests with id "%1" does not exist.',
                $singleGenerateRequestsId
            ));
        }
        return $singleGenerateRequests;
    }

    /**
     * @inheritDoc
     */
    public function getList(
        \Magento\Framework\Api\SearchCriteriaInterface $criteria
    ) {
        $collection = $this->singleGenerateRequestsCollectionFactory->create();
        
        $this->collectionProcessor->process($criteria, $collection);
        
        $searchResults = $this->searchResultsFactory->create();
        $searchResults->setSearchCriteria($criteria);
        
        $items = [];
        foreach ($collection as $model) {
            $items[] = $model;
        }
        
        $searchResults->setItems($items);
        $searchResults->setTotalCount($collection->getSize());
        return $searchResults;
    }

    /**
     * @inheritDoc
     */
    public function delete(
        SingleGenerateRequestsInterface $singleGenerateRequests
    ) {
        try {
            $singleGenerateRequestsModel = $this->singleGenerateRequestsFactory->create();
            $this->resource->load($singleGenerateRequestsModel, $singleGenerateRequests->getSingleGenerateRequestsId());
            $this->resource->delete($singleGenerateRequestsModel);
        } catch (\Exception $exception) {
            throw new CouldNotDeleteException(__(
                'Could not delete the single_generate_requests: %1',
                $exception->getMessage()
            ));
        }
        return true;
    }

    /**
     * @inheritDoc
     */
    public function deleteById($singleGenerateRequestsId)
    {
        return $this->delete($this->get($singleGenerateRequestsId));
    }
}
