<?php
/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

namespace WriteTextAI\WriteTextAI\Model;

use Magento\Framework\Model\AbstractModel;
use Magento\Framework\DataObject\IdentityInterface;
use WriteTextAI\WriteTextAI\Api\Data\SettingInterface;
use WriteTextAI\WriteTextAI\Model\ResourceModel\Setting as SettingResource;

class Setting extends AbstractModel implements IdentityInterface, SettingInterface
{
    public const CACHE_TAG = 'writetextai_setting';

    /**
     * @inheritDoc
     */
    protected function _construct()
    {
        $this->_init(SettingResource::class);
    }
    
    /**
     * Get identities
     *
     * @return array
     */
    public function getIdentities()
    {
        return [self::CACHE_TAG . '_' . $this->getSettingName()];
    }
    
    /**
     * @inheritDoc
     */
    public function getSettingId()
    {
        return $this->getData(self::SETTING_ID);
    }

    /**
     * @inheritDoc
     */
    public function setSettingId($settingId)
    {
        return $this->setData(self::SETTING_ID, $settingId);
    }

    /**
     * @inheritDoc
     */
    public function getSettingName()
    {
        return $this->getData(self::SETTING_NAME);
    }

    /**
     * @inheritDoc
     */
    public function setSettingName($settingName)
    {
        return $this->setData(self::SETTING_NAME, $settingName);
    }

    /**
     * @inheritDoc
     */
    public function getValue()
    {
        return $this->getData(self::VALUE);
    }

    /**
     * @inheritDoc
     */
    public function setValue($value)
    {
        return $this->setData(self::VALUE, $value);
    }

    /**
     * @inheritDoc
     */
    public function getEtag()
    {
        return $this->getData(self::ETAG);
    }

    /**
     * @inheritDoc
     */
    public function setEtag($etag)
    {
        return $this->setData(self::ETAG, $etag);
    }
}
