<?php
/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

namespace WriteTextAI\WriteTextAI\Model\OptionSource\Filter;

use WriteTextAI\WriteTextAI\Helper\Data;
use WriteTextAI\WriteTextAI\Model\TemplatesApiManager;
use WriteTextAI\WriteTextAI\ViewModel\AiModels;
use Magento\Framework\App\CacheInterface;

class Fields
{
    /**
     * make sure the values match the ones in the api
     */
    public const PAGE_TITLE = 'page title';

    public const PAGE_DESCRIPTION = 'page description';

    public const PRODUCT_DESCRIPTION = 'product description';

    public const EXCERPT = 'excerpt';

    public const OPEN_GRAPH = 'open graph text';

    public const CATEGORY_PAGE_TITLE = 'category page title';

    public const CATEGORY_PAGE_DESCRIPTION = 'category page description';

    public const CATEGORY_DESCRIPTION = 'category description';

    public const CATEGORY_MAPPING = [
        'page_title' => self::CATEGORY_PAGE_TITLE,
        'page_description' => self::CATEGORY_PAGE_DESCRIPTION,
        'category_description' => self::CATEGORY_DESCRIPTION
    ];

    public const STATUS_MAPPING = [
        'generated' => 'Generate',
        'transferred' => 'Transferred,Magento'
    ];

    public const STATUSES = [
        'generated',
        'transferred'
    ];

    public const TEMPLATE_SETTINGS_CACHE_KEY = 'writetext_ai_template_settings';

    /**
     * @var array
     */
    protected $templateSettings = [];

    /**
     * @var Data
     */
    protected $helper;

    /**
     * @var TemplatesApiManager
     */
    protected $templatesApiManager;

    /**
     * @var AiModels
     */
    protected $aiModels;

    /**
     * @var CacheInterface
     */
    protected $cache;

    /**
     * Constructor
     *
     * @param Data $helper
     * @param TemplatesApiManager $templatesApiManager
     * @param AiModels $aiModels
     * @param CacheInterface $cache
     */
    public function __construct(
        Data $helper,
        TemplatesApiManager $templatesApiManager,
        AiModels $aiModels,
        CacheInterface $cache
    ) {
        $this->helper = $helper;
        $this->templatesApiManager = $templatesApiManager;
        $this->aiModels = $aiModels;
        $this->cache = $cache;
    }
    
    /**
     * Get current template settings
     *
     * @param string $field
     *
     * @return array
     */
    public function getCurrentTemplateSettings($field)
    {
        $templateSettings = $this->cache->load(self::TEMPLATE_SETTINGS_CACHE_KEY);
        
        if (!$templateSettings) {
            $templateSettings = $this->templatesApiManager->getCurrentTemplateSettings();
            $templateSettings = json_encode($templateSettings);
            $this->cache->save(
                $templateSettings,
                self::TEMPLATE_SETTINGS_CACHE_KEY
            );
        }
        $templateSettings = json_decode($templateSettings, true);
        
        if ($templateSettings) {
            if ($field) {
                if (isset($templateSettings[$field])) {
                    return $templateSettings[$field]['selections'];
                }
            } else {
                return $templateSettings;
            }
        }

        return [];
    }
}
