<?php
/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

declare(strict_types=1);

namespace WriteTextAI\WriteTextAI\Model;

use Magento\Framework\Api\SearchCriteria\CollectionProcessorInterface;
use Magento\Framework\Exception\CouldNotDeleteException;
use Magento\Framework\Exception\CouldNotSaveException;
use Magento\Framework\Exception\NoSuchEntityException;
use WriteTextAI\WriteTextAI\Api\FullAutomationRequestsRepositoryInterface;
use WriteTextAI\WriteTextAI\Api\Data\FullAutomationRequestsInterface;
use WriteTextAI\WriteTextAI\Api\Data\FullAutomationRequestsInterfaceFactory;
use WriteTextAI\WriteTextAI\Api\Data\FullAutomationRequestsSearchResultsInterfaceFactory;
use WriteTextAI\WriteTextAI\Model\ResourceModel\FullAutomationRequests as ResourceFullAutomationRequests;
use WriteTextAI\WriteTextAI\Model\ResourceModel\FullAutomationRequests\CollectionFactory
    as FullAutomationRequestsCollectionFactory;

class FullAutomationRequestsRepository implements FullAutomationRequestsRepositoryInterface
{

    /**
     * @var ResourceFullAutomationRequests
     */
    protected $resource;

    /**
     * @var CollectionProcessorInterface
     */
    protected $collectionProcessor;

    /**
     * @var FullAutomationRequests
     */
    protected $searchResultsFactory;

    /**
     * @var FullAutomationRequestsCollectionFactory
     */
    protected $fullAutomationRequestsCollectionFactory;

    /**
     * @var FullAutomationRequestsInterfaceFactory
     */
    protected $fullAutomationRequestsFactory;

    /**
     * @param ResourceFullAutomationRequests $resource
     * @param FullAutomationRequestsInterfaceFactory $fullAutomationRequestsFactory
     * @param FullAutomationRequestsCollectionFactory $fullAutomationRequestsCollectionFactory
     * @param FullAutomationRequestsSearchResultsInterfaceFactory $searchResultsFactory
     * @param CollectionProcessorInterface $collectionProcessor
     */
    public function __construct(
        ResourceFullAutomationRequests $resource,
        FullAutomationRequestsInterfaceFactory $fullAutomationRequestsFactory,
        FullAutomationRequestsCollectionFactory $fullAutomationRequestsCollectionFactory,
        FullAutomationRequestsSearchResultsInterfaceFactory $searchResultsFactory,
        CollectionProcessorInterface $collectionProcessor
    ) {
        $this->resource = $resource;
        $this->fullAutomationRequestsFactory = $fullAutomationRequestsFactory;
        $this->fullAutomationRequestsCollectionFactory = $fullAutomationRequestsCollectionFactory;
        $this->searchResultsFactory = $searchResultsFactory;
        $this->collectionProcessor = $collectionProcessor;
    }

    /**
     * @inheritDoc
     */
    public function save(
        FullAutomationRequestsInterface $fullAutomationRequests
    ) {
        try {
            $this->resource->save($fullAutomationRequests);
        } catch (\Exception $exception) {
            throw new CouldNotSaveException(__(
                'Could not save the fullAutomationRequests: %1',
                $exception->getMessage()
            ));
        }
        return $fullAutomationRequests;
    }

    /**
     * @inheritDoc
     */
    public function get($fullAutomationRequestsId)
    {
        $fullAutomationRequests = $this->fullAutomationRequestsFactory->create();
        $this->resource->load($fullAutomationRequests, $fullAutomationRequestsId);
        if (!$fullAutomationRequests->getId()) {
            throw new NoSuchEntityException(__(
                'full_automation_requests with id "%1" does not exist.',
                $fullAutomationRequestsId
            ));
        }
        return $fullAutomationRequests;
    }

    /**
     * @inheritDoc
     */
    public function getList(
        \Magento\Framework\Api\SearchCriteriaInterface $criteria
    ) {
        $collection = $this->fullAutomationRequestsCollectionFactory->create();
        
        $this->collectionProcessor->process($criteria, $collection);
        
        $searchResults = $this->searchResultsFactory->create();
        $searchResults->setSearchCriteria($criteria);
        
        $items = [];
        foreach ($collection as $model) {
            $items[] = $model;
        }
        
        $searchResults->setItems($items);
        $searchResults->setTotalCount($collection->getSize());
        return $searchResults;
    }

    /**
     * @inheritDoc
     */
    public function delete(
        FullAutomationRequestsInterface $fullAutomationRequests
    ) {
        try {
            $fullAutomationRequestsModel = $this->fullAutomationRequestsFactory->create();
            $this->resource->load($fullAutomationRequestsModel, $fullAutomationRequests->getFullAutomationRequestsId());
            $this->resource->delete($fullAutomationRequestsModel);
        } catch (\Exception $exception) {
            throw new CouldNotDeleteException(__(
                'Could not delete the full_automation_requests: %1',
                $exception->getMessage()
            ));
        }
        return true;
    }

    /**
     * @inheritDoc
     */
    public function deleteById($fullAutomationRequestsId)
    {
        return $this->delete($this->get($fullAutomationRequestsId));
    }
}
