<?php
/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

namespace WriteTextAI\WriteTextAI\Model\Config\Source;

use Magento\Framework\Data\OptionSourceInterface;
use WriteTextAI\WriteTextAI\Model\Magento\User;

class PublishedAs implements OptionSourceInterface
{
    /**
     * @var User
     */
    protected $magentoUser;

    /**
     * Constructor
     *
     * @param User $magentoUser
     */
    public function __construct(
        User $magentoUser
    ) {
        $this->magentoUser = $magentoUser;
    }
    
    /**
     * Get options
     *
     * @return array
     */
    public function toOptionArray()
    {
        $users = $this->magentoUser->getUsersForNotification();
        
        $options = [];
        
        foreach ($users as $user) {
            $options[] = [
                'value' => $user['id'],
                'label' => $user['firstname'] .' '. $user['lastname'] .' ('.$user['email'] .')'
            ];
        }
        
        return $options;
    }
}
