<?php
/**
 * Copyright ©  All rights reserved.
 * See COPYING.txt for license details.
 */
declare(strict_types=1);

namespace WriteTextAI\WriteTextAI\Model;

use Magento\Framework\Api\SearchCriteria\CollectionProcessorInterface;
use Magento\Framework\Exception\CouldNotDeleteException;
use Magento\Framework\Exception\CouldNotSaveException;
use Magento\Framework\Exception\NoSuchEntityException;
use WriteTextAI\WriteTextAI\Api\BulkKeywordAnalysisRequestsRepositoryInterface;
use WriteTextAI\WriteTextAI\Api\Data\BulkKeywordAnalysisRequestsInterface;
use WriteTextAI\WriteTextAI\Api\Data\BulkKeywordAnalysisRequestsInterfaceFactory;
use WriteTextAI\WriteTextAI\Api\Data\BulkKeywordAnalysisRequestsSearchResultsInterfaceFactory;
use WriteTextAI\WriteTextAI\Model\ResourceModel\BulkKeywordAnalysisRequests as ResourceBulkKeywordAnalysisRequests;
use WriteTextAI\WriteTextAI\Model\ResourceModel\BulkKeywordAnalysisRequests\CollectionFactory
    as BulkKeywordAnalysisRequestsCollectionFactory;

class BulkKeywordAnalysisRequestsRepository implements BulkKeywordAnalysisRequestsRepositoryInterface
{

    /**
     * @var CollectionProcessorInterface
     */
    protected $collectionProcessor;

    /**
     * @var ResourceBulkKeywordAnalysisRequests
     */
    protected $resource;

    /**
     * @var BulkKeywordAnalysisRequestsCollectionFactory
     */
    protected $bulkKeywordAnalysisRequestsCollectionFactory;

    /**
     * @var BulkKeywordAnalysisRequestsInterfaceFactory
     */
    protected $bulkKeywordAnalysisRequestsFactory;

    /**
     * @var BulkKeywordAnalysisRequests
     */
    protected $searchResultsFactory;

    /**
     * @param ResourceBulkKeywordAnalysisRequests $resource
     * @param BulkKeywordAnalysisRequestsInterfaceFactory $bulkKeywordAnalysisRequestsFactory
     * @param BulkKeywordAnalysisRequestsCollectionFactory $bulkKeywordAnalysisRequestsCollectionFactory
     * @param BulkKeywordAnalysisRequestsSearchResultsInterfaceFactory $searchResultsFactory
     * @param CollectionProcessorInterface $collectionProcessor
     */
    public function __construct(
        ResourceBulkKeywordAnalysisRequests $resource,
        BulkKeywordAnalysisRequestsInterfaceFactory $bulkKeywordAnalysisRequestsFactory,
        BulkKeywordAnalysisRequestsCollectionFactory $bulkKeywordAnalysisRequestsCollectionFactory,
        BulkKeywordAnalysisRequestsSearchResultsInterfaceFactory $searchResultsFactory,
        CollectionProcessorInterface $collectionProcessor
    ) {
        $this->resource = $resource;
        $this->bulkKeywordAnalysisRequestsFactory = $bulkKeywordAnalysisRequestsFactory;
        $this->bulkKeywordAnalysisRequestsCollectionFactory = $bulkKeywordAnalysisRequestsCollectionFactory;
        $this->searchResultsFactory = $searchResultsFactory;
        $this->collectionProcessor = $collectionProcessor;
    }

    /**
     * @inheritDoc
     */
    public function save(
        BulkKeywordAnalysisRequestsInterface $bulkKeywordAnalysisRequests
    ) {
        try {
            $this->resource->save($bulkKeywordAnalysisRequests);
        } catch (\Exception $exception) {
            throw new CouldNotSaveException(__(
                'Could not save the bulkKeywordAnalysisRequests: %1',
                $exception->getMessage()
            ));
        }
        return $bulkKeywordAnalysisRequests;
    }

    /**
     * @inheritDoc
     */
    public function get($bulkKeywordAnalysisRequestsId)
    {
        $bulkKeywordAnalysisRequests = $this->bulkKeywordAnalysisRequestsFactory->create();
        $this->resource->load($bulkKeywordAnalysisRequests, $bulkKeywordAnalysisRequestsId);
        if (!$bulkKeywordAnalysisRequests->getId()) {
            throw new NoSuchEntityException(__(
                'BulkKeywordAnalysisRequests with id "%1" does not exist.',
                $bulkKeywordAnalysisRequestsId
            ));
        }
        return $bulkKeywordAnalysisRequests;
    }

    /**
     * @inheritDoc
     */
    public function getList(
        \Magento\Framework\Api\SearchCriteriaInterface $criteria
    ) {
        $collection = $this->bulkKeywordAnalysisRequestsCollectionFactory->create();
        
        $this->collectionProcessor->process($criteria, $collection);
        
        $searchResults = $this->searchResultsFactory->create();
        $searchResults->setSearchCriteria($criteria);
        
        $items = [];
        foreach ($collection as $model) {
            $items[] = $model;
        }
        
        $searchResults->setItems($items);
        $searchResults->setTotalCount($collection->getSize());
        return $searchResults;
    }

    /**
     * @inheritDoc
     */
    public function delete(
        BulkKeywordAnalysisRequestsInterface $bulkKeywordAnalysisRequests
    ) {
        try {
            $bulkKeywordAnalysisRequestsModel = $this->bulkKeywordAnalysisRequestsFactory->create();
            $this->resource->load(
                $bulkKeywordAnalysisRequestsModel,
                $bulkKeywordAnalysisRequests->getBulkkeywordanalysisrequestsId()
            );
            $this->resource->delete($bulkKeywordAnalysisRequestsModel);
        } catch (\Exception $exception) {
            throw new CouldNotDeleteException(__(
                'Could not delete the BulkKeywordAnalysisRequests: %1',
                $exception->getMessage()
            ));
        }
        return true;
    }

    /**
     * @inheritDoc
     */
    public function deleteById($bulkKeywordAnalysisRequestsId)
    {
        return $this->delete($this->get($bulkKeywordAnalysisRequestsId));
    }
}
