<?php
/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */
declare(strict_types=1);

namespace WriteTextAI\WriteTextAI\Model;

use Magento\Framework\Model\AbstractModel;
use WriteTextAI\WriteTextAI\Api\Data\AiCategoryInterface;

class AiCategory extends AbstractModel implements AiCategoryInterface
{

    /**
     * @inheritDoc
     */
    public function _construct()
    {
        $this->_init(\WriteTextAI\WriteTextAI\Model\ResourceModel\AiCategory::class);
    }

    /**
     * @inheritDoc
     */
    public function getAicategoryId()
    {
        return $this->getData(self::AICATEGORY_ID);
    }

    /**
     * @inheritDoc
     */
    public function setAicategoryId($aicategoryId)
    {
        return $this->setData(self::AICATEGORY_ID, $aicategoryId);
    }

    /**
     * @inheritDoc
     */
    public function getCategoryId()
    {
        return $this->getData(self::CATEGORY_ID);
    }

    /**
     * @inheritDoc
     */
    public function setCategoryId($categoryId)
    {
        return $this->setData(self::CATEGORY_ID, $categoryId);
    }

    /**
     * @inheritDoc
     */
    public function getStoreId()
    {
        return $this->getData(self::STORE_ID);
    }

    /**
     * @inheritDoc
     */
    public function setStoreId($storeId)
    {
        return $this->setData(self::STORE_ID, $storeId);
    }

    /**
     * @inheritDoc
     */
    public function getRepresentativeProductsSelected()
    {
        return $this->getData(self::REPRESENTATIVE_PRODUCTS_SELECTED);
    }

    /**
     * @inheritDoc
     */
    public function setRepresentativeProductsSelected($representativeProductsSelected)
    {
        return $this->setData(self::REPRESENTATIVE_PRODUCTS_SELECTED, $representativeProductsSelected);
    }

    /**
     * @inheritDoc
     */
    public function getOtherDetailsChecked()
    {
        return $this->getData(self::OTHER_DETAILS_CHECKED);
    }

    /**
     * @inheritDoc
     */
    public function setOtherDetailsChecked($otherDetailsChecked)
    {
        return $this->setData(self::OTHER_DETAILS_CHECKED, $otherDetailsChecked);
    }

    /**
     * @inheritDoc
     */
    public function getOtherDetails()
    {
        return $this->getData(self::OTHER_DETAILS);
    }

    /**
     * @inheritDoc
     */
    public function setOtherDetails($otherDetails)
    {
        return $this->setData(self::OTHER_DETAILS, $otherDetails);
    }

    /**
     * @inheritDoc
     */
    public function getGeneratedAt()
    {
        return $this->getData(self::GENERATED_AT);
    }

    /**
     * @inheritDoc
     */
    public function setGeneratedAt($generatedAt)
    {
        return $this->setData(self::GENERATED_AT, $generatedAt);
    }

    /**
     * @inheritDoc
     */
    public function getEditedAt()
    {
        return $this->getData(self::EDITED_AT);
    }

    /**
     * @inheritDoc
     */
    public function setEditedAt($editedAt)
    {
        return $this->setData(self::EDITED_AT, $editedAt);
    }

    /**
     * @inheritDoc
     */
    public function getTransferredAt()
    {
        return $this->getData(self::TRANSFERRED_AT);
    }

    /**
     * @inheritDoc
     */
    public function setTransferredAt($transferredAt)
    {
        return $this->setData(self::TRANSFERRED_AT, $transferredAt);
    }

    /**
     * @inheritDoc
     */
    public function getRefreshAt()
    {
        return $this->getData(self::REFRESH_AT);
    }

    /**
     * @inheritDoc
     */
    public function setRefreshAt($refreshAt)
    {
        return $this->setData(self::REFRESH_AT, $refreshAt);
    }

    /**
     * @inheritDoc
     */
    public function getReviewedAt()
    {
        return $this->getData(self::REVIEWED_AT);
    }

    /**
     * @inheritDoc
     */
    public function setReviewedAt($reviewedAt)
    {
        return $this->setData(self::REVIEWED_AT, $reviewedAt);
    }
}
