<?php
/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

namespace WriteTextAI\WriteTextAI\Helper\Categories;

use Magento\Catalog\Model\Attribute\ScopeOverriddenValueFactory;
use Magento\Framework\App\Helper\Context;
use Magento\Store\Model\ScopeInterface;

class Fields extends \Magento\Framework\App\Helper\AbstractHelper
{
    public const CATEGORY_MAPPING_SETTINGS_CONFIG_PATH = 'writetextai_settings/category_mapping';

    /**
     * @var ScopeOverriddenValueFactory
     */
    protected $scopeOverriddenValueFactory;

    /**
     * @var array
     */
    protected $mappingSettings = [];

    /**
     * Constructor
     *
     * @param Context $context
     * @param ScopeOverriddenValueFactory $scopeOverriddenValueFactory
     */
    public function __construct(
        Context $context,
        ScopeOverriddenValueFactory $scopeOverriddenValueFactory
    ) {
        $this->scopeOverriddenValueFactory = $scopeOverriddenValueFactory;
        parent::__construct($context);
    }

    /**
     * Check if using default values
     *
     * @param \Magento\Catalog\Model\Category $category
     * @param int $storeId
     * @param string $field
     * @return bool
     */
    public function isUsingDefaultValues($category, $storeId, $field)
    {
        $isOverriden = $this->scopeOverriddenValueFactory->create()->containsValue(
            \Magento\Catalog\Api\Data\CategoryInterface::class,
            $category,
            $field,
            $storeId
        );

        return !$isOverriden;
    }
        
    /**
     * Get config value
     *
     * @param string $path
     * @param int|null $storeId
     * @return mixed
     */
    public function conf($path, $storeId = null)
    {
        return $this->scopeConfig->getValue($path, ScopeInterface::SCOPE_STORE, $storeId);
    }

    /**
     * Get mapping settings
     *
     * @param string $path
     *
     * @return array
     */
    public function getMappingSettings($path = '')
    {
        $hardCodedMapping = [
            'page_title' => 'meta_title',
            'page_description' => 'meta_description',
            'category_description' => 'description'
        ];
        if (!$path && !empty($this->mappingSettings)) {
            return $this->mappingSettings;
        }
        
        $path = $path ? '/' . $path : '';
        $settings = $this->conf(self::CATEGORY_MAPPING_SETTINGS_CONFIG_PATH . $path);

        if (!$path) {
            $settings = array_merge($hardCodedMapping, (array)$settings);
            $this->mappingSettings = $settings;
        }

        return $settings;
    }

    /**
     * Get default mapping
     *
     * @return mixed
     */
    public function getDefaultMapping()
    {
        return [
            'page_title' => 'meta_title',
            'page_description' => 'meta_description',
            'category_description' => 'description'
        ];
    }
}
