<?php
/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

declare(strict_types=1);

namespace WriteTextAI\WriteTextAI\Cron;

use Magento\User\Model\UserFactory;
use WriteTextAI\WriteTextAI\Model\Api\Session as ApiSession;
use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Store\Model\ScopeInterface;

class BaseCron
{
    /**
     * @var UserFactory
     */
    protected $userFactory;

    /**
     * @var ApiSession
     */
    protected $apiSession;

    /**
     * @var ScopeConfigInterface
     */
    protected $scopeConfig;

    /**
     * Constructor
     *
     * @param UserFactory $userFactory
     * @param ApiSession $apiSession
     * @param ScopeConfigInterface $scopeConfig
     */
    public function __construct(
        UserFactory $userFactory,
        ApiSession $apiSession,
        ScopeConfigInterface $scopeConfig
    ) {
        $this->userFactory = $userFactory;
        $this->apiSession = $apiSession;
        $this->scopeConfig = $scopeConfig;
    }
}
