<?php
/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

namespace WriteTextAI\WriteTextAI\Controller\Adminhtml\Grid;

use Magento\Backend\App\Action;
use Magento\Backend\App\Action\Context;
use Magento\Framework\Controller\ResultFactory;
use WriteTextAI\WriteTextAI\ViewModel\Premium;
use WriteTextAI\WriteTextAI\WtaiTrait\PremiumDataTrait;

class GetCredits extends Action
{
    use PremiumDataTrait;

    /**
     * @var Premium
     */
    protected $premium;

    /**
     * Constructor
     *
     * @param Context $context
     * @param Premium $premium
     */
    public function __construct(
        Context $context,
        Premium $premium
    ) {
        $this->premium = $premium;
        parent::__construct($context);
    }

    /**
     * Execute
     *
     * @return Json
     */
    public function execute()
    {
        $response = $this->resultFactory->create(ResultFactory::TYPE_JSON);
        $response->setData($this->collectPremiumData(true));

        return $response;
    }
}
