<?php
/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

namespace WriteTextAI\WriteTextAI\Block\Adminhtml\System\Config\Field;

use Magento\Config\Block\System\Config\Form\Field;
use Magento\Framework\Data\Form\Element\AbstractElement;

class CustomOpenGraphMapping extends Field
{
    /**
     * @inheritdoc
     */
    protected function _getElementHtml(AbstractElement $element)
    {
        $html = parent::_getElementHtml($element);
        
        $html .= '<script type="text/javascript">
            require([
                "jquery",
                "jquery/ui"
            ], function ($) {
                $(document).ready(function () {
                    var elementName = "' . $element->getName() . '",
                        elementSelector = "[name=\"" + elementName + "\"]",
                        pageTitleName = "groups[mapping][fields][page_title][value]",
                        pageDescriptionName = "groups[mapping][fields][page_description][value]",
                        productDescriptionName = "groups[mapping][fields][product_description][value]",
                        shortProductDescriptionName = "groups[mapping][fields][short_product_description][value]",
                        openGraphName = "groups[mapping][fields][open_graph][value]",
                        customOpenGraph = "groups[mapping][fields][custom_open_graph][value]",
                        fields = [
                            pageTitleName,
                            pageDescriptionName,
                            productDescriptionName,
                            shortProductDescriptionName,
                            openGraphName
                        ];

                    function disableValues() {
                        var value = $(elementSelector).val();
                        var selectedValues = [];
                        if (value == "0") {
                            for (var i = 0; i < fields.length; i++) {
                                if (fields[i] == openGraphName && 
                                    $("[name=\"" + customOpenGraph + "\"]").val() == "0") {
                                    continue;
                                }
                                selectedValues.push($("[name=\"" + fields[i] + "\"]").val());
                            }
                            for (var i = 0; i < fields.length; i++) {
                                var selectedVal = $("[name=\"" + fields[i] + "\"]").val();
                                $("[name=\"" + fields[i] + "\"] > option").each(function() {
                                    if (selectedValues.includes($(this).val())) {
                                        if ($(this).val() != selectedVal) {
                                            $(this).prop("disabled", true);
                                        }
                                    } else {
                                        $(this).prop("disabled", false);
                                    }
                                });
                            }
                        }
                    }

                    $(elementSelector).on("change", disableValues);
                });
            });
        </script>';
        
        return $html;
    }
}
