<?php
/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

declare(strict_types=1);

namespace WriteTextAI\WriteTextAI\Block\Adminhtml\Grid;

use Magento\Backend\Block\Template\Context;
use WriteTextAI\WriteTextAI\Helper\Data;
use WriteTextAI\WriteTextAI\Model\UserFieldsSelectedManager;
use WriteTextAI\WriteTextAI\Model\OptionSource\Filter\Stores;
use WriteTextAI\WriteTextAI\ViewModel\UserFieldsSelected;
use WriteTextAI\WriteTextAI\ViewModel\CronStatus;

class TransferPrompt extends \Magento\Backend\Block\Template
{
    /**
     * @var string
     */
    protected $_template = 'WriteTextAI_WriteTextAI::grid/massactions/transfer_prompt.phtml';

    /**
     * @var UserFieldsSelected
     */
    protected $userFieldsSelected;

    /**
     * @var Data
     */
    protected $helper;

    /**
     * @var Stores
     */
    protected $stores;

    /**
     * @var CronStatus
     */
    protected $cronStatus;

    /**
     * Constructor
     *
     * @param Context $context
     * @param UserFieldsSelected $userFieldsSelected
     * @param Data $helper
     * @param Stores $stores
     * @param CronStatus $cronStatus
     * @param array $data
     */
    public function __construct(
        Context $context,
        UserFieldsSelected $userFieldsSelected,
        Data $helper,
        Stores $stores,
        CronStatus $cronStatus,
        array $data = []
    ) {
        $this->userFieldsSelected = $userFieldsSelected;
        $this->helper = $helper;
        $this->stores = $stores;
        $this->cronStatus = $cronStatus;
        parent::__construct($context, $data);
    }

    /**
     * Get text types
     *
     * @return array
     */
    public function getFields()
    {
        $fields = [[
            'value' => 'page_title',
            'label' => __('Meta title')
        ], [
            'value' => 'page_description',
            'label' => __('Meta description')
        ], [
            'value' => 'product_description',
            'label' => __('Description')
        ], [
            'value' => 'short_product_description',
            'label' => __('Short description')
        ]];

        if ($this->helper->getCustomOpenGraph()) {
            $fields[] = [
                'value' => 'open_graph',
                'label' => __('Open Graph text')
            ];
        }
        
        return $fields;
    }

    /**
     * Get fields selected
     *
     * @return array
     */
    public function getFieldsSelected()
    {
        return $this->userFieldsSelected->getUserFieldsSelected(
            UserFieldsSelectedManager::ACTION_TYPE_BULK_TRANSFER_FIELDS,
            'product',
            'grid'
        );
    }

    /**
     * Get stores
     *
     * @return array
     */
    public function getStores()
    {
        return $this->stores->toOptionArray();
    }

    /**
     * Is cron enabled
     *
     * @return bool
     */
    public function isCronRunning()
    {
        return $this->cronStatus->getIsCronRunning();
    }
}
