<?php
/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

 declare(strict_types=1);

namespace WriteTextAI\WriteTextAI\Api;

use Magento\Framework\Api\SearchCriteriaInterface;

interface UserFeedbackRepositoryInterface
{
    /**
     * Save user_feedback
     *
     * @param \WriteTextAI\WriteTextAI\Api\Data\UserFeedbackInterface $userFeedback
     * @return \WriteTextAI\WriteTextAI\Api\Data\UserFeedbackInterface
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function save(
        \WriteTextAI\WriteTextAI\Api\Data\UserFeedbackInterface $userFeedback
    );

    /**
     * Retrieve user_feedback
     *
     * @param string $userFeedbackId
     * @return \WriteTextAI\WriteTextAI\Api\Data\UserFeedbackInterface
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function get($userFeedbackId);

    /**
     * Retrieve user_feedback matching the specified criteria.
     *
     * @param \Magento\Framework\Api\SearchCriteriaInterface $searchCriteria
     * @return \WriteTextAI\WriteTextAI\Api\Data\UserFeedbackSearchResultsInterface
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function getList(
        \Magento\Framework\Api\SearchCriteriaInterface $searchCriteria
    );

    /**
     * Delete user_feedback
     *
     * @param \WriteTextAI\WriteTextAI\Api\Data\UserFeedbackInterface $userFeedback
     * @return bool true on success
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function delete(
        \WriteTextAI\WriteTextAI\Api\Data\UserFeedbackInterface $userFeedback
    );

    /**
     * Delete user_feedback by ID
     *
     * @param string $userFeedbackId
     * @return bool true on success
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function deleteById($userFeedbackId);
}
