<?php
/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */
declare(strict_types=1);

namespace WriteTextAI\WriteTextAI\Api\Data;

interface SettingInterface
{
    public const SETTING_NAME = 'setting_name';

    public const VALUE = 'value';

    public const ETAG = 'etag';
    
    public const SETTING_ID = 'setting_id';

    /**
     * Get setting_id
     *
     * @return string|null
     */
    public function getSettingId();

    /**
     * Set setting_id
     *
     * @param string $settingId
     * @return \WriteTextAI\WriteTextAI\Setting\Api\Data\SettingInterface
     */
    public function setSettingId($settingId);

    /**
     * Get setting_name
     *
     * @return string|null
     */
    public function getSettingName();

    /**
     * Set setting_name
     *
     * @param string $settingName
     * @return \WriteTextAI\WriteTextAI\Setting\Api\Data\SettingInterface
     */
    public function setSettingName($settingName);

    /**
     * Get value
     *
     * @return string|null
     */
    public function getValue();

    /**
     * Set value
     *
     * @param string $value
     * @return \WriteTextAI\WriteTextAI\Setting\Api\Data\SettingInterface
     */
    public function setValue($value);

    /**
     * Get etag
     *
     * @return string|null
     */
    public function getEtag();

    /**
     * Set etag
     *
     * @param string $etag
     * @return \WriteTextAI\WriteTextAI\Setting\Api\Data\SettingInterface
     */
    public function setEtag($etag);
}
