<?php
/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

declare(strict_types=1);

namespace WriteTextAI\WriteTextAI\Api\Data;

interface BulkGenerateRequestsInterface
{

    public const BULK_GENERATE_REQUESTS_ID = 'id';

    public const USER = 'user';

    public const REQUEST_ID = 'request_id';

    public const STORE_ID = 'store_id';

    public const ENTITY_TYPE = 'entity_type';

    public const RECORD_ID = 'record_id';

    /**
     * Get bulk_generate_requests_id
     *
     * @return string|null
     */
    public function getBulkGenerateRequestsId();

    /**
     * Set bulk_generate_requests_id
     *
     * @param string $bulkGenerateRequestsId
     * @return \WriteTextAI\WriteTextAI\BulkGenerateRequests\Api\Data\BulkGenerateRequestsInterface
     */
    public function setBulkGenerateRequestsId($bulkGenerateRequestsId);

    /**
     * Get user
     *
     * @return string|null
     */
    public function getUser();

    /**
     * Set user
     *
     * @param string $user
     * @return \WriteTextAI\WriteTextAI\BulkGenerateRequests\Api\Data\BulkGenerateRequestsInterface
     */
    public function setUser($user);

    /**
     * Get request_id
     *
     * @return string|null
     */
    public function getRequestId();

    /**
     * Set request_id
     *
     * @param string $requestId
     * @return \WriteTextAI\WriteTextAI\BulkGenerateRequests\Api\Data\BulkGenerateRequestsInterface
     */
    public function setRequestId($requestId);

    /**
     * Get store_id
     *
     * @return string|null
     */
    public function getStoreId();

    /**
     * Set store_id
     *
     * @param string $storeId
     * @return \WriteTextAI\WriteTextAI\BulkGenerateRequests\Api\Data\BulkGenerateRequestsInterface
     */
    public function setStoreId($storeId);

    /**
     * Get entity_type
     *
     * @return string|null
     */
    public function getEntityType();

    /**
     * Set entity_type
     *
     * @param string $entityType
     * @return \WriteTextAI\WriteTextAI\BulkGenerateRequests\Api\Data\BulkGenerateRequestsInterface
     */
    public function setEntityType($entityType);

    /**
     * Get record_id
     *
     * @return string|null
     */
    public function getRecordId();

    /**
     * Set record_id
     *
     * @param string $recordId
     * @return \WriteTextAI\WriteTextAI\BulkGenerateRequests\Api\Data\BulkGenerateRequestsInterface
     */
    public function setRecordId($recordId);
}
