<?php
/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

namespace WriteTextAI\WriteTextAI\Api\Data;

interface AiProductInterface
{
    public const PRODUCT_ID = 'product_id';

    public const STORE_ID = 'store_id';

    public const PRODUCT_ATTRIBUTES_SELECTED = 'product_attributes_selected';

    public const OTHER_DETAILS_CHECKED = 'other_details_checked';

    public const OTHER_DETAILS = 'other_details';

    public const GENERATED_AT = 'generated_at';

    public const EDITED_AT = 'edited_at';

    public const TRANSFERRED_AT = 'transferred_at';

    public const REFERESH_AT = 'refresh_at';

    public const REVIEWED_AT = 'reviewed_at';

    /**
     * Set product id
     *
     * @param int $id
     * @return $this
     */
    public function setProductId($id);

    /**
     * Get product id
     *
     * @return int
     */
    public function getProductId();

    /**
     * Set store id
     *
     * @param string $storeId
     * @return $this
     */
    public function setStoreId($storeId);

    /**
     * Get store id
     *
     * @return string
     */
    public function getStoreId();

    /**
     * Set product attributes selected
     *
     * @param string $productAttributesSelected
     * @return $this
     */
    public function setProductAttributesSelected($productAttributesSelected);

    /**
     * Get product attributes selected
     *
     * @return string
     */
    public function getProductAttributesSelected();

    /**
     * Set other details checked
     *
     * @param int $otherDetailsChecked
     * @return $this
     */
    public function setOtherDetailsChecked($otherDetailsChecked);

    /**
     * Get other details checked
     *
     * @return int
     */
    public function getOtherDetailsChecked();

    /**
     * Set other details
     *
     * @param string $otherDetails
     * @return $this
     */
    public function setOtherDetails($otherDetails);

    /**
     * Get other details
     *
     * @return string
     */
    public function getOtherDetails();

    /**
     * Set generated at
     *
     * @param string $generatedAt
     * @return $this
     */
    public function setGeneratedAt($generatedAt);

    /**
     * Get generated at
     *
     * @return string
     */
    public function getGeneratedAt();

    /**
     * Set edited at
     *
     * @param string $editedAt
     * @return $this
     */
    public function setEditedAt($editedAt);

    /**
     * Get edited at
     *
     * @return string
     */
    public function getEditedAt();

    /**
     * Set transferred at
     *
     * @param string $transferredAt
     * @return $this
     */
    public function setTransferredAt($transferredAt);

    /**
     * Get transferred at
     *
     * @return string
     */
    public function getTransferredAt();

    /**
     * Set refresh at
     *
     * @param string $refreshAt
     * @return $this
     */
    public function setRefreshAt($refreshAt);

    /**
     * Get refresh at
     *
     * @return string
     */
    public function getRefreshAt();

    /**
     * Get reviewed_at
     *
     * @return string|null
     */
    public function getReviewedAt();

    /**
     * Set reviewed_at
     *
     * @param string $reviewedAt
     * @return \WriteTextAI\WriteTextAI\AiProduct\Api\Data\AiProductInterface
     */
    public function setReviewedAt($reviewedAt);
}
