<?php
/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

declare(strict_types=1);

namespace WriteTextAI\WriteTextAI\Api;

use Magento\Framework\Api\SearchCriteriaInterface;

interface BulkTransferRequestsRepositoryInterface
{

    /**
     * Save bulk_transfer_requests
     *
     * @param \WriteTextAI\WriteTextAI\Api\Data\BulkTransferRequestsInterface $bulkTransferRequests
     * @return \WriteTextAI\WriteTextAI\Api\Data\BulkTransferRequestsInterface
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function save(
        \WriteTextAI\WriteTextAI\Api\Data\BulkTransferRequestsInterface $bulkTransferRequests
    );

    /**
     * Retrieve bulk_transfer_requests
     *
     * @param string $bulkTransferRequestsId
     * @return \WriteTextAI\WriteTextAI\Api\Data\BulkTransferRequestsInterface
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function get($bulkTransferRequestsId);

    /**
     * Retrieve bulk_transfer_requests matching the specified criteria.
     *
     * @param \Magento\Framework\Api\SearchCriteriaInterface $searchCriteria
     * @return \WriteTextAI\WriteTextAI\Api\Data\BulkTransferRequestsSearchResultsInterface
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function getList(
        \Magento\Framework\Api\SearchCriteriaInterface $searchCriteria
    );

    /**
     * Delete bulk_transfer_requests
     *
     * @param \WriteTextAI\WriteTextAI\Api\Data\BulkTransferRequestsInterface $bulkTransferRequests
     * @return bool true on success
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function delete(
        \WriteTextAI\WriteTextAI\Api\Data\BulkTransferRequestsInterface $bulkTransferRequests
    );

    /**
     * Delete bulk_transfer_requests by ID
     *
     * @param string $bulkTransferRequestsId
     * @return bool true on success
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function deleteById($bulkTransferRequestsId);
}
