<?php
/**
 * Copyright ©  All rights reserved.
 * See COPYING.txt for license details.
 */
declare(strict_types=1);

namespace WriteTextAI\WriteTextAI\Api;

use Magento\Framework\Api\SearchCriteriaInterface;

interface BulkKeywordAnalysisRequestsRepositoryInterface
{
    /**
     * Save BulkKeywordAnalysisRequests
     *
     * @param \WriteTextAI\WriteTextAI\Api\Data\BulkKeywordAnalysisRequestsInterface $bulkKeywordAnalysisRequests
     * @return \WriteTextAI\WriteTextAI\Api\Data\BulkKeywordAnalysisRequestsInterface
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function save(
        \WriteTextAI\WriteTextAI\Api\Data\BulkKeywordAnalysisRequestsInterface $bulkKeywordAnalysisRequests
    );

    /**
     * Retrieve BulkKeywordAnalysisRequests
     *
     * @param string $bulkkeywordanalysisrequestsId
     * @return \WriteTextAI\WriteTextAI\Api\Data\BulkKeywordAnalysisRequestsInterface
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function get($bulkkeywordanalysisrequestsId);

    /**
     * Retrieve BulkKeywordAnalysisRequests matching the specified criteria.
     *
     * @param \Magento\Framework\Api\SearchCriteriaInterface $searchCriteria
     * @return \WriteTextAI\WriteTextAI\Api\Data\BulkKeywordAnalysisRequestsSearchResultsInterface
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function getList(
        \Magento\Framework\Api\SearchCriteriaInterface $searchCriteria
    );

    /**
     * Delete BulkKeywordAnalysisRequests
     *
     * @param \WriteTextAI\WriteTextAI\Api\Data\BulkKeywordAnalysisRequestsInterface $bulkKeywordAnalysisRequests
     * @return bool true on success
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function delete(
        \WriteTextAI\WriteTextAI\Api\Data\BulkKeywordAnalysisRequestsInterface $bulkKeywordAnalysisRequests
    );

    /**
     * Delete BulkKeywordAnalysisRequests by ID
     *
     * @param string $bulkkeywordanalysisrequestsId
     * @return bool true on success
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function deleteById($bulkkeywordanalysisrequestsId);
}
