<?php
/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

declare(strict_types=1);

namespace WriteTextAI\WriteTextAI\Api;

interface AiProductRepositoryInterface
{
    /**
     * Save Products
     *
     * @param \WriteTextAI\WriteTextAI\Api\Data\AiProductInterface $product
     * @return \WriteTextAI\WriteTextAI\Api\Data\AiProductInterface
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function save(
        \WriteTextAI\WriteTextAI\Api\Data\AiProductInterface $product
    );

    /**
     * Retrieve Products
     *
     * @param string $productsId
     * @return \WriteTextAI\WriteTextAI\Api\Data\AiProductInterface
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function get($productsId);

    /**
     * Retrieve Products matching the specified criteria.
     *
     * @param \Magento\Framework\Api\SearchCriteriaInterface $searchCriteria
     * @return \WriteTextAI\WriteTextAI\Api\Data\AiProductSearchResultsInterface
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function getList(
        \Magento\Framework\Api\SearchCriteriaInterface $searchCriteria
    );

    /**
     * Delete Products
     *
     * @param \WriteTextAI\WriteTextAI\Api\Data\AiProductInterface $products
     * @return bool true on success
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function delete(
        \WriteTextAI\WriteTextAI\Api\Data\AiProductInterface $products
    );

    /**
     * Delete Products by ID
     *
     * @param string $productsId
     * @return bool true on success
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function deleteById($productsId);
}
