<?php
/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */
declare(strict_types=1);

namespace WriteTextAI\WriteTextAI\Api;

use Magento\Framework\Api\SearchCriteriaInterface;

interface AiCategoryRepositoryInterface
{
    /**
     * Save AiCategory
     *
     * @param \WriteTextAI\WriteTextAI\Api\Data\AiCategoryInterface $aiCategory
     * @return \WriteTextAI\WriteTextAI\Api\Data\AiCategoryInterface
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function save(
        \WriteTextAI\WriteTextAI\Api\Data\AiCategoryInterface $aiCategory
    );

    /**
     * Retrieve AiCategory
     *
     * @param string $aicategoryId
     * @return \WriteTextAI\WriteTextAI\Api\Data\AiCategoryInterface
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function get($aicategoryId);

    /**
     * Retrieve AiCategory matching the specified criteria.
     *
     * @param \Magento\Framework\Api\SearchCriteriaInterface $searchCriteria
     * @return \WriteTextAI\WriteTextAI\Api\Data\AiCategorySearchResultsInterface
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function getList(
        \Magento\Framework\Api\SearchCriteriaInterface $searchCriteria
    );

    /**
     * Delete AiCategory
     *
     * @param \WriteTextAI\WriteTextAI\Api\Data\AiCategoryInterface $aiCategory
     * @return bool true on success
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function delete(
        \WriteTextAI\WriteTextAI\Api\Data\AiCategoryInterface $aiCategory
    );

    /**
     * Delete AiCategory by ID
     *
     * @param string $aicategoryId
     * @return bool true on success
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function deleteById($aicategoryId);
}
