/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

define([
    'jquery',
    'WriteTextAI_WriteTextAI/js/model/total-credits'
], function ($, totalCredits) {
    'use strict';

    /**
     * Update premium.
     *
     * @param {Object} data
     * @returns {void}
     */
    function updatePremium(data)
    {
        if (typeof data.is_terms_accepted !== 'undefined' && !data.is_terms_accepted) {
            window.location.reload();
            return;
        }

        const updates = {
            'total_credits': totalCredits.totalCredits,
            'available_credits': totalCredits.availableCredits,
            'is_premium': totalCredits.isPremium,
            'is_free_premium_credits': totalCredits.isFreePremium,
            'is_already_premium': totalCredits.isFreeCreditsAlreadyPremium,
            'is_welcome_premium_20': totalCredits.welcomePremium20,
            'is_unlocked_premium': totalCredits.unlockedPremium,
            'is_unlocked_free_trial': totalCredits.unlockedFreeTrial,
            'is_no_credits_free_trial': totalCredits.noCreditsFreeTrial,
            'is_unlocked_professional': totalCredits.unlockedProfessional,
            'is_unlocked_enterprise': totalCredits.unlockedEnterprise,
            'membership_type': totalCredits.membershipType,
            'has_pro_access': totalCredits.hasProAccess,
            'subscription_expiration': totalCredits.subscriptionExpiration
        };

        Object.entries(updates).forEach(([key, updateFn]) => {
            if (data[key] !== undefined) {
                updateFn(data[key]);
                /** if value is 0, trigger mutation */
                if (data[key] === 0) {
                    updateFn.valueHasMutated();
                }
            }
        });
    }

    return {
        updatePremium: updatePremium
    };
});
