/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

define([
    'jquery',
    'underscore',
    'WriteTextAI_WriteTextAI/js/utils/grid/image-upload',
    'WriteTextAI_WriteTextAI/js/model/grid/error-messages',
    'WriteTextAI_WriteTextAI/js/model/grid/notifications',
    'WriteTextAI_WriteTextAI/js/model/grid/listing',
    'WriteTextAI_WriteTextAI/js/model/grid/popups/keyword-analysis-progress',
    'WriteTextAI_WriteTextAI/js/model/grid/popups/image-upload-progressbar',
    'WriteTextAI_WriteTextAI/js/utils/grid/actions'
], function (
    $,
    _,
    generateImageUploadUtils,
    errorMessagesModel,
    notifications,
    listingModel,
    keywordAnalysisProgressModel,
    imageUploadProgressbarModel,
    actionsUtils
) {
    'use strict';

    /**
     * Bulk keyword analysis
     *
     * @param {Object} action - Action data.
     * @param {Object} data - Selections data.
     * @param {Object} settings - Form settings.
     *
     * @returns {void}
     */
    function bulkKeywordAnalysis(self, action, data, settings)
    {
        /**
         * imageUploadProgressbarModel.toCancel(false);
         * generateImageUploadUtils.uploadImages(self, action, data, settings, 'bulkKeywordAnalysisRequest');
         */
        bulkKeywordAnalysisRequest(self, action, data, settings);
    }

    /**
     * Bulk keyword analysis request
     *
     * @param {Object} self - Self data.
     * @param {Object} action - Action data.
     * @param {Object} data - Selections data.
     * @param {Object} settings - Form settings.
     *
     * @returns {void}
     */
    function bulkKeywordAnalysisRequest(self, action, data, settings)
    {
        keywordAnalysisProgressModel.status({});
        
        var selections = actionsUtils.processSelections(data, settings, self.defaultStoreId);
                    
        notifications.addNewKeywordAnalysisStatus(
            data.selected,
            listingModel.currentUser(),
            data
        );
        notifications.opened(true);

        actionsUtils.pingApi(self, action, selections, mainAjaxRequest, removeNotification);
    }

    /**
     * Main ajax request for bulk keyword analysis
     * via POST request.
     *
     * @param {Object} self - Self data.
     * @param {Object} action - Action data.
     * @param {Object} selections - Selections data.
     *
     * @returns {void}
     */
    function mainAjaxRequest(self, action, selections)
    {
        $.ajax({
            url: action.url + '?form_key=' + encodeURIComponent(window.FORM_KEY),
            type: 'POST',
            data: JSON.stringify(selections),
            contentType: 'application/json',
            dataType: 'json',
            showLoader: false,
            success: function (response) {
                if (!response.success) {
                    errorMessagesModel.messages.push(response.message);
                    notifications.statuses.remove(function (status) {
                        return status.id === notifications.koTempId;
                    });
                    notifications.triggerDismissAll(true);
                    if (response.unauthorized) {
                        window.location.href = response.login_url;
                    }
                    
                    if (response.reload) {
                        self.gridReload();
                    }
                } else {
                    notifications.updateTempStatusId(response.api_response.requestId, notifications.koTempId);
                    notifications.currentBulkRequestId(response.api_response.requestId);
                }
            }
        });
    }

    /**
     * Remove notification
     *
     * @returns {void}
     */
    function removeNotification()
    {
        notifications.statuses.remove(function (status) {
            return status.id === notifications.koTempId;
        });
    }

    return {
        bulkKeywordAnalysis: bulkKeywordAnalysis,
        bulkKeywordAnalysisRequest: bulkKeywordAnalysisRequest,
        mainAjaxRequest: mainAjaxRequest,
        removeNotification: removeNotification
    };
});
