/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

define(['ko', 'domReady!'], function (ko) {
    'use strict';

    var messages = ko.observable({
        page_title: {},
        page_description: {},
        product_description: {},
        excerpt: {},
        open_graph: {}
        }),
        index = ko.observable({
            page_title: 0,
            page_description: 0,
            product_description: 0,
            excerpt: 0,
            open_graph: 0
        }),
        fieldsGenerated = ko.observable({
            page_title: null,
            page_description: null,
            product_description: null,
            excerpt: null,
            open_graph: null
        }),
        imagesGenerating = ko.observableArray([]),
        imagesGenerated = ko.observableArray([]),
        errorFields = ko.observableArray([]),
        errorMessage = ko.observable(''),
        selectedFields = ko.observableArray([]),
        generating = ko.observable(false),
        showMessage = ko.observable(false),
        message = ko.observable(''),
        singleGeneratingStatuses = ko.observableArray([]),
        checkingIsSingleRequest = ko.observable(false),
        
        /** SignalR Connection Status */
        connectionStatus = ko.observable('Disconnected'), /** Disconnected, Connecting, Connected, Reconnecting */
        connectionState = ko.observable(''), /** Raw SignalR connection state */
        isConnected = ko.observable(false),
        lastConnectionTime = ko.observable(null),
        retryAttempts = ko.observable(0),
        connectionError = ko.observable(''),

        editTitleStatusText = ko.observable(''),

        triggerContinueBulkTransfer = ko.observable(false),
        toGetGenerated = ko.observable(false),
        triggerHandleUserReturn = ko.observable(false);

    return {
        messages: messages,
        index: index,
        fieldsGenerated: fieldsGenerated,
        imagesGenerating: imagesGenerating,
        imagesGenerated: imagesGenerated,
        errorFields: errorFields,
        errorMessage: errorMessage,
        selectedFields: selectedFields,
        generating: generating,
        showMessage: showMessage,
        message: message,
        singleGeneratingStatuses: singleGeneratingStatuses,
        checkingIsSingleRequest: checkingIsSingleRequest,
        
        /** SignalR Connection Status */
        connectionStatus: connectionStatus,
        connectionState: connectionState,
        isConnected: isConnected,
        lastConnectionTime: lastConnectionTime,
        retryAttempts: retryAttempts,
        connectionError: connectionError,

        editTitleStatusText: editTitleStatusText,
        
        triggerContinueBulkTransfer: triggerContinueBulkTransfer,
        toGetGenerated: toGetGenerated,
        triggerHandleUserReturn: triggerHandleUserReturn
    };
});
