/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

define(['ko', 'domReady!'], function (ko) {
    'use strict';

    var optimizing = ko.observable(false),
        isUploading = ko.observable(false),
        optimizationFailed = ko.observable(false),
        imageUploadFailed = ko.observable(false),
        imageUploadFailedIdentifier = ko.observable(false),
        optimized = ko.observable(false),
        optimizingId = ko.observable(''),
        optimizingStoreId = ko.observable(''),
        autoGenerateOrRewriteChecked = ko.observable(false),
        refreshingData = ko.observable(false),
        uploadErrorMessage = ko.observable('');

    var historyMode = ko.observable(false),
        statuses = ko.observableArray([]),
        optimizationData = ko.observable({}),
        snapshotData = ko.observable({}),
        customProgressText = ko.observable(''),
        customOptFailedText = ko.observable('');

    var allTypeOneKoStatuses = ko.observable([]);

    var storeCurrentOptimizationData = ko.observable({}),
        currentlySelectedSnapshot = ko.observable({}),
        editKeywordRankingVisible = ko.observable(false),
        editKeywordRankingItems = ko.observable([]);

    return {
        optimizing: optimizing,
        historyMode: historyMode,
        statuses: statuses,
        optimizationData: optimizationData,
        snapshotData: snapshotData,
        optimizationFailed: optimizationFailed,
        customProgressText: customProgressText,
        customOptFailedText: customOptFailedText,
        imageUploadFailed: imageUploadFailed,
        imageUploadFailedIdentifier: imageUploadFailedIdentifier,
        isUploading: isUploading,
        optimized: optimized,
        storeCurrentOptimizationData: storeCurrentOptimizationData,
        currentlySelectedSnapshot: currentlySelectedSnapshot,
        optimizingId: optimizingId,
        optimizingStoreId: optimizingStoreId,
        autoGenerateOrRewriteChecked: autoGenerateOrRewriteChecked,
        refreshingData: refreshingData,
        editKeywordRankingVisible: editKeywordRankingVisible,
        editKeywordRankingItems: editKeywordRankingItems,
        uploadErrorMessage: uploadErrorMessage,
        allTypeOneKoStatuses: allTypeOneKoStatuses
    };
});
