/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

define(['uiRegistry'], function (registry) {
    'use strict';

    return {
        /**
         * Reloads the ui component.
         *
         * @param {String} gridName
         * @param {Boolean} reload
         * @returns {void}
         */
        reloadUIComponent: function (
            gridName,
            showLoader = true,
            debounce = false
        ) {
            var target;

            if (gridName) {
                target = registry.get(gridName);

                if (target && typeof target === 'object') {
                    target.reload({
                        refresh: true,
                        custom: true,
                        showLoader: showLoader,
                        debounce: debounce
                    });
                }
            }
        }
    };
});
