/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

define([
    'jquery',
    'uiComponent',
    'WriteTextAI_WriteTextAI/js/model/grid/prompt',
    'WriteTextAI_WriteTextAI/js/model/edit/select-template',
    'WriteTextAI_WriteTextAI/js/model/grid/error-messages',
    'WriteTextAI_WriteTextAI/js/model/grid/field-templates',
], function (
    $,
    Component,
    prompt,
    selectTemplateModel,
    errorMessagesModel,
    fieldTemplatesModel
) {
    'use strict';

    /**
     * @var {Component} self
     */
    var self;

    return Component.extend({
        defaults: {
            selector: '#wtai-last-load-data'
        },

        /** @inheritdoc */
        initialize: function () {
            this._super();
            console.log('Last Load Data component initialized');
            self = this;
            this.getLastLoadData();
        },

        /** @inheritdoc */
        initObservable: function () {
            this._super().observe([]);

            return this;
        },

        /**
         * Get last load data
         */
        getLastLoadData: function () {
            $.ajax({
                url: this.getNeededDataUrl,
                type: 'GET',
                data: {
                    entityType: this.entityType
                },
                dataType: 'json',
                showLoader: false,
                success: function (response) {
                    prompt.templateSettings(response.templates);
                    prompt.fieldsTemplateSettings(response.fieldsTemplateSettings);
                    selectTemplateModel.templateOptions(response.templateOptions);
                    fieldTemplatesModel.templateSettings(response.templates);
                    if (response.entityType === 'Product' && response.pingSuccess === false) {
                        errorMessagesModel.messages.push(response.pingMessage);
                    }
                }
            });
        }
    });
});
