<?php
/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

namespace WriteTextAI\WriteTextAI\ViewModel;

use WriteTextAI\WriteTextAI\Model\SettingManager;
use WriteTextAI\WriteTextAI\Model\Api\Session as ApiSession;

class Settings implements \Magento\Framework\View\Element\Block\ArgumentInterface
{
    /**
     * @var SettingManager
     */
    protected $settingManager;

    /**
     * @var ApiSession
     */
    protected $apiSession;

    /**
     * @var array
     */
    protected $data = [];

    /**
     * @var array
     */
    protected $formalLanguages = [];
    
    /**
     * Constructor
     *
     * @param SettingManager $settingManager
     * @param ApiSession $apiSession
     */
    public function __construct(
        SettingManager $settingManager,
        ApiSession $apiSession
    ) {
        $this->settingManager = $settingManager;
        $this->apiSession = $apiSession;
    }

    /**
     * Get settings
     *
     * @param string $name
     * @return array
     */
    public function getSettings($name)
    {
        if (isset($this->data[$name])) {
            return $this->data[$name];
        }

        return $this->getValue($name);
    }

    /**
     * Get formal languages
     *
     * @param string $locale
     * @return array
     */
    public function getFormalLanguages($locale)
    {
        if (isset($this->formalLanguages[$locale])) {
            return $this->formalLanguages[$locale];
        }

        return $this->getFormalLanguagesValue($locale);
    }

    /**
     * Set value
     *
     * @param string $name
     * @param array $value
     * @return void
     */
    protected function setValue($name, $value)
    {
        $this->data[$name] = $value;
    }

    /**
     * Set formal languages
     *
     * @param string $locale
     * @param array $value
     * @return void
     */
    protected function setFormalLanguages($locale, $value)
    {
        $this->formalLanguages[$locale] = $value;
    }
    
    /**
     * Get value
     *
     * @param string $name
     * @return array
     */
    protected function getValue($name)
    {
        if (in_array($name, SettingManager::LOCALIZED_SETTINGS)) {
            $locale = $this->apiSession->getRegionIndependentLanguage();
            $value = $this->settingManager->getSettings($name, $locale);
        } else {
            $value = $this->settingManager->getSettings($name);
        }

        $this->setValue($name, $value);

        return $value;
    }

    /**
     * Get form languages
     *
     * @param string $locale
     * @return array
     */
    protected function getFormalLanguagesValue($locale)
    {
        $value = $this->settingManager->getSettings('formalLanguages', $locale);
        $this->setFormalLanguages($locale, $value);

        return $value;
    }
}
