<?php
/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

namespace WriteTextAI\WriteTextAI\ViewModel;

use Magento\Framework\AuthorizationInterface;

class Permissions implements \Magento\Framework\View\Element\Block\ArgumentInterface
{
    public const TRANSFER_ACL_RESOURCE = 'WriteTextAI_WriteTextAI::transfer';

    public const GENERATE_ACL_RESOURCE = 'WriteTextAI_WriteTextAI::generate';

    public const PRODUCT_DETAILS_ACL_RESOURCE = 'WriteTextAI_WriteTextAI::product_details';

    public const EDIT_ACL_RESOURCE = 'WriteTextAI_WriteTextAI::edit';

    public const ATTR_ACL_RESOURCE = 'WriteTextAI_WriteTextAI::modify_attributes';

    public const TONE_STYLE_ACL_RESOURCE = 'WriteTextAI_WriteTextAI::modify_tone_style';

    public const WORDS_ACL_RESOURCE = 'WriteTextAI_WriteTextAI::modify_words';

    public const REVIEW_ACL_RESOURCE = 'WriteTextAI_WriteTextAI::review';

    public const KEYWORD_ANALYSIS_ACL_RESOURCE = 'WriteTextAI_WriteTextAI::keyword_analysis';

    /**
     * @var AuthorizationInterface
     */
    protected $authorization;

    /**
     * @var array
     */
    protected $permissions = [];

    /**
     * Constructor
     *
     * @param AuthorizationInterface $authorization
     */
    public function __construct(
        AuthorizationInterface $authorization
    ) {
        $this->authorization = $authorization;
    }

    /**
     * Check if transfer button is allowed
     *
     * @return bool
     */
    public function isTransferAllowed()
    {
        if (!isset($this->permissions['transfer'])) {
            $this->permissions['transfer'] = $this->authorization->isAllowed(self::TRANSFER_ACL_RESOURCE);
        }
        
        return $this->permissions['transfer'];
    }

    /**
     * Check if mark as reviewed is allowed
     *
     * @return bool
     */
    public function isReviewAllowed()
    {
        if (!isset($this->permissions['review'])) {
            $this->permissions['review'] = $this->authorization->isAllowed(self::REVIEW_ACL_RESOURCE);
        }
        
        return $this->permissions['review'];
    }

    /**
     * Get generate permission
     *
     * @return bool
     */
    public function isGenerateAllowed()
    {
        if (!isset($this->permissions['generate'])) {
            $this->permissions['generate'] = $this->authorization->isAllowed(self::GENERATE_ACL_RESOURCE);
        }
        
        return $this->permissions['generate'];
    }

    /**
     * Get product details permission
     *
     * @return bool
     */
    public function isProductDetailsAllowed()
    {
        if (!isset($this->permissions['product_details'])) {
            $this->permissions['product_details'] = $this->authorization->isAllowed(self::PRODUCT_DETAILS_ACL_RESOURCE);
        }

        return $this->permissions['product_details'];
    }

    /**
     * Get edit permission
     *
     * @return bool
     */
    public function isEditAllowed()
    {
        if (!isset($this->permissions['edit'])) {
            $this->permissions['edit'] = $this->authorization->isAllowed(self::EDIT_ACL_RESOURCE);
        }

        return $this->permissions['edit'];
    }

    /**
     * Get attribute permission
     *
     * @return bool
     */
    public function isAttrAllowed()
    {
        if (!isset($this->permissions['attr'])) {
            $this->permissions['attr'] = $this->authorization->isAllowed(self::ATTR_ACL_RESOURCE);
        }

        return $this->permissions['attr'];
    }

    /**
     * Get tone and style permission
     *
     * @return bool
     */
    public function isToneStyleAllowed()
    {
        if (!isset($this->permissions['tone_style'])) {
            $this->permissions['tone_style'] = $this->authorization->isAllowed(self::TONE_STYLE_ACL_RESOURCE);
        }

        return $this->permissions['tone_style'];
    }

    /**
     * Get words permission
     *
     * @return bool
     */
    public function isWordsAllowed()
    {
        if (!isset($this->permissions['words'])) {
            $this->permissions['words'] = $this->authorization->isAllowed(self::WORDS_ACL_RESOURCE);
        }

        return $this->permissions['words'];
    }

    /**
     * Get keyword analysis permission
     *
     * @return bool
     */
    public function isKeywordAnalysisAllowed()
    {
        if (!isset($this->permissions['keyword_analysis'])) {
            $this->permissions['keyword_analysis'] = $this->authorization->isAllowed(self::KEYWORD_ANALYSIS_ACL_RESOURCE);
        }

        return $this->permissions['keyword_analysis'];
    }
}
