<?php
/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

namespace WriteTextAI\WriteTextAI\Ui\DataProvider\Categories\Listing;

use Magento\Framework\View\Element\UiComponent\DataProvider\SearchResult;

class Collection extends SearchResult
{
    /**
     * Override _initSelect to add custom columns
     *
     * @return void
     */
    protected function _initSelect()
    {
        $this->addFilterToMap('entity_id', 'main_table.entity_id');
        $this->addFilterToMap(
            'thumbnail',
            new \Zend_Db_Expr('COALESCE(thumbnail.value, default_thumbnail.value)')
        );
        $this->addFilterToMap(
            'status',
            new \Zend_Db_Expr('COALESCE(status.value, default_status.value)')
        );
        $this->addFilterToMap(
            'name',
            new \Zend_Db_Expr('COALESCE(name.value, default_name.value)')
        );
        $this->addFilterToMap(
            'mg_page_title',
            new \Zend_Db_Expr('COALESCE(mg_page_title.value, default_mg_page_title.value)')
        );
        $this->addFilterToMap(
            'mg_page_description',
            new \Zend_Db_Expr('COALESCE(mg_page_description.value, default_mg_page_description.value)')
        );
        $this->addFilterToMap(
            'mg_category_description',
            new \Zend_Db_Expr('COALESCE(mg_category_description.value, default_mg_category_description.value)')
        );
        $this->addFilterToMap('generated_at', 'wtai_categories.generated_at');
        $this->addFilterToMap('edited_at', 'wtai_categories.edited_at');
        $this->addFilterToMap('transferred_at', 'wtai_categories.transferred_at');
        $this->addFilterToMap('store_id', 'store.store_id');
        parent::_initSelect();
    }
}
