<?php
/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

namespace WriteTextAI\WriteTextAI\Ui\Components\Products\Listing\Column;

use Magento\Framework\View\Element\UiComponentFactory;
use Magento\Framework\View\Element\UiComponent\ContextInterface;
use Magento\Backend\Model\UrlInterface;
use Magento\Ui\Component\Listing\Columns\Column;
use WriteTextAI\WriteTextAI\Helper\Product as ProductHelper;
use Magento\Framework\View\LayoutInterface;
use Magento\Catalog\Model\Product\Visibility;
use WriteTextAI\WriteTextAI\ViewModel\Permissions;

class Actions extends Column
{
    public const URL_PATH_TRANSFER = 'wtai/grid/transfer';

    /**
     * @var UrlInterface
     */
    protected $urlBuilder;

    /**
     * @var ProductHelper
     */
    protected $productHelper;

    /**
     * @var LayoutInterface
     */
    protected $layout;

    /**
     * @var Permissions
     */
    protected $permissions;

    /**
     * Constructor
     *
     * @param ContextInterface $context
     * @param UiComponentFactory $uiComponentFactory
     * @param UrlInterface $urlBuilder
     * @param ProductHelper $productHelper
     * @param LayoutInterface $layout
     * @param Permissions $permissions
     * @param array $components
     * @param array $data
     */
    public function __construct(
        ContextInterface $context,
        UiComponentFactory $uiComponentFactory,
        UrlInterface $urlBuilder,
        ProductHelper $productHelper,
        LayoutInterface $layout,
        Permissions $permissions,
        array $components = [],
        array $data = []
    ) {
        $this->urlBuilder = $urlBuilder;
        $this->productHelper = $productHelper;
        $this->layout = $layout;
        $this->permissions = $permissions;
        parent::__construct(
            $context,
            $uiComponentFactory,
            $components,
            $data
        );
    }

    /**
     * Prepare Data Source
     *
     * @param array $dataSource
     * @return array
     */
    public function prepareDataSource(array $dataSource)
    {
        if (isset($dataSource['data']['items'])) {
            foreach ($dataSource['data']['items'] as &$item) {
                $name = $this->getData('name');
                if (isset($item['entity_id'])) {
                    $item[$name]['edit'] = [
                        'label' => __('Edit'),
                        'record_id' => $item['entity_id'],
                        'store_id' => $item['store_id']
                    ];

                    if ($this->permissions->isTransferAllowed()) {
                        $item[$name]['transfer'] = [
                            'label' => __('Transfer to Magento'),
                            'record_id' => $item['entity_id'],
                            'store_id' => $item['store_id'],
                            'url'  => $this->urlBuilder->getUrl(static::URL_PATH_TRANSFER),
                            'confirm' => [
                                'title' => __('Transfer to Magento'),
                                'message' => $this->getTransferConfirmContent()
                            ]
                        ];
                    }

                    if ((int)$item['visibility'] !== Visibility::VISIBILITY_NOT_VISIBLE
                        && isset($item['view_link'])
                    ) {
                        $item[$name]['view'] = [
                            'label' => __('View'),
                            'href'  => $item['view_link'],
                            'target' => '_blank'
                        ];
                    }
                }
            }
        }

        return $dataSource;
    }

    /**
     * Get transfer confirm content
     *
     * @return string
     */
    protected function getTransferConfirmContent()
    {
        $block = $this->layout->createBlock(\WriteTextAI\WriteTextAI\Block\Adminhtml\Grid\TransferPrompt::class);
        return $block->toHtml();
    }
}
