<?php
/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

namespace WriteTextAI\WriteTextAI\Plugin\Catalog\Helper;

use Magento\Framework\App\RequestInterface;
use WriteTextAI\WriteTextAI\Helper\Preview;
use Magento\Framework\Url\DecoderInterface;

class Output
{
    /**
     * @var RequestInterface
     */
    protected $request;

    /**
     * @var Preview
     */
    protected $previewHelper;

    /**
     * @var DecoderInterface
     */
    protected $urlDecoder;

    /**
     * Constructor
     *
     * @param RequestInterface $request
     * @param Preview $previewHelper
     * @param DecoderInterface $urlDecoder
     */
    public function __construct(
        RequestInterface $request,
        Preview $previewHelper,
        DecoderInterface $urlDecoder
    ) {
        $this->request = $request;
        $this->previewHelper = $previewHelper;
        $this->urlDecoder = $urlDecoder;
    }

    /**
     * After product attribute
     *
     * @param \Magento\Catalog\Helper\Output $subject
     * @param mixed $result
     * @param \Magento\Catalog\Model\Product $product
     * @param string $attributeHtml
     * @param string $attributeName
     * @return mixed
     */
    public function afterProductAttribute(
        \Magento\Catalog\Helper\Output $subject,
        $result,
        $product,
        $attributeHtml,
        $attributeName
    ) {
        if ($this->request->getFullActionName() == 'catalog_product_view' &&
            $this->request->getParam('wtai-preview')
        ) {
            $previewText = $this->getAttributePreviewValue($product->getId(), $attributeName);

            if ($previewText) {
                //$result = nl2br($previewText);
                $result = $previewText;
            }
        }

        return $result;
    }

    /**
     * Get attribute preview value
     *
     * @param int $productId
     * @param string $attributeCode
     * @return string
     */
    protected function getAttributePreviewValue($productId, $attributeCode)
    {
        $userId = $this->urlDecoder->decode($this->request->getParam('wtai-preview'));
        $preview = $this->previewHelper->getAttributePreviewValue($productId, $userId, $attributeCode);

        return $preview;
    }

    /**
     * After product attribute
     *
     * @param \Magento\Catalog\Helper\Output $subject
     * @param mixed $result
     * @param \Magento\Catalog\Model\Category $category
     * @param string $attributeHtml
     * @param string $attributeName
     * @return mixed
     */
    public function afterCategoryAttribute(
        \Magento\Catalog\Helper\Output $subject,
        $result,
        $category,
        $attributeHtml,
        $attributeName
    ) {
        if ($this->request->getFullActionName() == 'catalog_category_view' &&
            $this->request->getParam('wtai-preview')
        ) {
            $previewText = $this->getCategoryAttributePreviewValue($category->getId(), $attributeName);

            if ($previewText) {
                //$result = nl2br($previewText);
                $result = $previewText;
            }
        }

        return $result;
    }

    /**
     * Get attribute preview value
     *
     * @param int $categoryId
     * @param string $attributeCode
     * @return string
     */
    protected function getCategoryAttributePreviewValue($categoryId, $attributeCode)
    {
        $userId = $this->urlDecoder->decode($this->request->getParam('wtai-preview'));
        $preview = $this->previewHelper->getCategoryAttributePreviewValue($categoryId, $userId, $attributeCode);

        return $preview;
    }
}
