<?php
/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

declare(strict_types=1);

namespace WriteTextAI\WriteTextAI\Model;

use Magento\Framework\Api\SearchCriteria\CollectionProcessorInterface;
use Magento\Framework\Exception\CouldNotDeleteException;
use Magento\Framework\Exception\CouldNotSaveException;
use Magento\Framework\Exception\NoSuchEntityException;
use WriteTextAI\WriteTextAI\Api\Data\UserFieldsSelectedInterface;
use WriteTextAI\WriteTextAI\Api\Data\UserFieldsSelectedInterfaceFactory;
use WriteTextAI\WriteTextAI\Api\Data\UserFieldsSelectedSearchResultsInterfaceFactory;
use WriteTextAI\WriteTextAI\Api\UserFieldsSelectedRepositoryInterface;
use WriteTextAI\WriteTextAI\Model\ResourceModel\UserFieldsSelected as ResourceUserFieldsSelected;
use WriteTextAI\WriteTextAI\Model\ResourceModel\UserFieldsSelected\CollectionFactory
    as UserFieldsSelectedCollectionFactory;

class UserFieldsSelectedRepository implements UserFieldsSelectedRepositoryInterface
{
    /**
     * @var ResourceUserFieldsSelected
     */
    protected $resource;

    /**
     * @var UserFieldsSelected
     */
    protected $searchResultsFactory;

    /**
     * @var UserFieldsSelectedCollectionFactory
     */
    protected $userFieldsSelectedCollectionFactory;

    /**
     * @var UserFieldsSelectedInterfaceFactory
     */
    protected $userFieldsSelectedFactory;

    /**
     * @var CollectionProcessorInterface
     */
    protected $collectionProcessor;

    /**
     * @param ResourceUserFieldsSelected $resource
     * @param UserFieldsSelectedInterfaceFactory $userFieldsSelectedFactory
     * @param UserFieldsSelectedCollectionFactory $userFieldsSelectedCollectionFactory
     * @param UserFieldsSelectedSearchResultsInterfaceFactory $searchResultsFactory
     * @param CollectionProcessorInterface $collectionProcessor
     */
    public function __construct(
        ResourceUserFieldsSelected $resource,
        UserFieldsSelectedInterfaceFactory $userFieldsSelectedFactory,
        UserFieldsSelectedCollectionFactory $userFieldsSelectedCollectionFactory,
        UserFieldsSelectedSearchResultsInterfaceFactory $searchResultsFactory,
        CollectionProcessorInterface $collectionProcessor
    ) {
        $this->resource = $resource;
        $this->userFieldsSelectedFactory = $userFieldsSelectedFactory;
        $this->userFieldsSelectedCollectionFactory = $userFieldsSelectedCollectionFactory;
        $this->searchResultsFactory = $searchResultsFactory;
        $this->collectionProcessor = $collectionProcessor;
    }

    /**
     * @inheritDoc
     */
    public function save(
        UserFieldsSelectedInterface $userFieldsSelected
    ) {
        try {
            $this->resource->save($userFieldsSelected);
        } catch (\Exception $exception) {
            throw new CouldNotSaveException(__(
                'Could not save the userFieldsSelected: %1',
                $exception->getMessage()
            ));
        }
        return $userFieldsSelected;
    }

    /**
     * @inheritDoc
     */
    public function get($userFieldsSelectedId)
    {
        $userFieldsSelected = $this->userFieldsSelectedFactory->create();
        $this->resource->load($userFieldsSelected, $userFieldsSelectedId);
        if (!$userFieldsSelected->getId()) {
            throw new NoSuchEntityException(__(
                'UserFieldsSelected with id "%1" does not exist.',
                $userFieldsSelectedId
            ));
        }
        return $userFieldsSelected;
    }

    /**
     * @inheritDoc
     */
    public function getList(
        \Magento\Framework\Api\SearchCriteriaInterface $criteria
    ) {
        $collection = $this->userFieldsSelectedCollectionFactory->create();
        
        $this->collectionProcessor->process($criteria, $collection);
        
        $searchResults = $this->searchResultsFactory->create();
        $searchResults->setSearchCriteria($criteria);
        
        $items = [];
        foreach ($collection as $model) {
            $items[] = $model;
        }
        
        $searchResults->setItems($items);
        $searchResults->setTotalCount($collection->getSize());
        return $searchResults;
    }

    /**
     * @inheritDoc
     */
    public function delete(
        UserFieldsSelectedInterface $userFieldsSelected
    ) {
        try {
            $userFieldsSelectedModel = $this->userFieldsSelectedFactory->create();
            $this->resource->load($userFieldsSelectedModel, $userFieldsSelected->getUserfieldsselectedId());
            $this->resource->delete($userFieldsSelectedModel);
        } catch (\Exception $exception) {
            throw new CouldNotDeleteException(__(
                'Could not delete the UserFieldsSelected: %1',
                $exception->getMessage()
            ));
        }
        return true;
    }

    /**
     * @inheritDoc
     */
    public function deleteById($userFieldsSelectedId)
    {
        return $this->delete($this->get($userFieldsSelectedId));
    }
}
