<?php
/**
 * @author 1902 Software
 * @copyright Copyright © 2023 1902 Software (https://1902software.com/magento/)
 * @package WriteTextAI_WriteTextAI
 */

namespace WriteTextAI\WriteTextAI\Model\OptionSource\Filter;

use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Framework\Escaper;
use Magento\Store\Model\System\Store as SystemStore;

class Stores extends \Magento\Store\Ui\Component\Listing\Column\Store\Options
{

    /**
     * @var Escaper
     */
    protected $escaper;

    /**
     * @var SystemStore
     */
    protected $systemStore;

    /**
     * @var ScopeConfigInterface
     */
    protected $scopeConfig;

    /**
     * Constructor
     *
     * @param SystemStore $systemStore
     * @param Escaper $escaper
     * @param ScopeConfigInterface $scopeConfig
     */
    public function __construct(
        SystemStore $systemStore,
        Escaper $escaper,
        ScopeConfigInterface $scopeConfig
    ) {
        $this->systemStore = $systemStore;
        $this->escaper = $escaper;
        $this->scopeConfig = $scopeConfig;

        parent::__construct(
            $systemStore,
            $escaper
        );
    }

    /**
     * Generate current options
     *
     * @return void
     */
    protected function generateCurrentOptions(): void
    {
        $websiteCollection = $this->systemStore->getWebsiteCollection();
        $groupCollection = $this->systemStore->getGroupCollection();
        $storeCollection = $this->systemStore->getStoreCollection();

        foreach ($websiteCollection as $website) {
            $groups = [];
            foreach ($groupCollection as $group) {
                if ($group->getWebsiteId() === $website->getId()) {
                    $stores = [];
                    foreach ($storeCollection as $store) {
                        if ($store->getGroupId() === $group->getId()) {
                            $stores[] = [
                                'label' => str_repeat(' ', 8) . $this->sanitizeName($store->getName()),
                                'value' => $store->getId(),
                            ];
                        }
                    }
                    if (!empty($stores)) {
                        $groups[] = [
                            'label' => str_repeat(' ', 4) . $this->sanitizeName($group->getName()),
                            'value' => array_values($stores),
                        ];
                    }
                }
            }
            if (!empty($groups)) {
                $this->currentOptions[] = [
                    'label' => $this->sanitizeName($website->getName()),
                    'value' => array_values($groups),
                ];
            }
        }
    }

    /**
     * Sanitize website/store option name
     *
     * @param string $name
     *
     * @return string
     */
    protected function sanitizeName($name)
    {
        $matches = [];
        preg_match('/\$[:]*{(.)*}/', $name ?: '', $matches);
        if (count($matches) > 0) {
            $name = $this->escaper->escapeHtml($this->escaper->escapeJs($name));
        } else {
            $name = $this->escaper->escapeHtml($name);
        }

        return $name;
    }
}
